/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.integration.jei;

import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.block.EPBlocks;
import me.jddev0.ep.block.entity.FluidTransposerBlockEntity;
import me.jddev0.ep.recipe.FluidTransposerRecipe;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;

public class FluidTransposerCategory
implements IRecipeCategory<RecipeHolder<FluidTransposerRecipe>> {
    public static final RecipeType<RecipeHolder<FluidTransposerRecipe>> TYPE = RecipeType.createFromVanilla((net.minecraft.world.item.crafting.RecipeType)FluidTransposerRecipe.Type.INSTANCE);
    private final IDrawable backgroundEmptying;
    private final IDrawable backgroundFilling;
    private final IDrawable icon;

    public FluidTransposerCategory(IGuiHelper helper) {
        ResourceLocation texture = EPAPI.id("textures/gui/recipe/misc_gui.png");
        this.backgroundEmptying = helper.createDrawable(texture, 1, 133, 143, 26);
        this.backgroundFilling = helper.createDrawable(texture, 1, 161, 143, 26);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)EPBlocks.FLUID_TRANSPOSER_ITEM.get()));
    }

    public RecipeType<RecipeHolder<FluidTransposerRecipe>> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"container.energizedpower.fluid_transposer");
    }

    public IDrawable getBackground() {
        return this.backgroundEmptying;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder iRecipeLayout, RecipeHolder<FluidTransposerRecipe> recipe, IFocusGroup iFocusGroup) {
        FluidStack fluid = ((FluidTransposerRecipe)recipe.value()).getFluid();
        if (((FluidTransposerRecipe)recipe.value()).getMode() == FluidTransposerBlockEntity.Mode.EMPTYING) {
            iRecipeLayout.addSlot(RecipeIngredientRole.INPUT, 1, 5).addIngredients(((FluidTransposerRecipe)recipe.value()).getInput());
            iRecipeLayout.addSlot(RecipeIngredientRole.OUTPUT, 64, 5).addItemStack(((FluidTransposerRecipe)recipe.value()).getOutput());
            iRecipeLayout.addSlot(RecipeIngredientRole.OUTPUT, 90, 5).addFluidStack(fluid.getFluid(), (long)fluid.getAmount(), fluid.getComponentsPatch());
        } else {
            iRecipeLayout.addSlot(RecipeIngredientRole.INPUT, 1, 5).addIngredients(((FluidTransposerRecipe)recipe.value()).getInput());
            iRecipeLayout.addSlot(RecipeIngredientRole.INPUT, 19, 5).addFluidStack(fluid.getFluid(), (long)fluid.getAmount(), fluid.getComponentsPatch());
            iRecipeLayout.addSlot(RecipeIngredientRole.OUTPUT, 90, 5).addItemStack(((FluidTransposerRecipe)recipe.value()).getOutput());
        }
    }

    public void draw(RecipeHolder<FluidTransposerRecipe> recipe, IRecipeSlotsView iRecipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        if (((FluidTransposerRecipe)recipe.value()).getMode() == FluidTransposerBlockEntity.Mode.FILLING) {
            this.backgroundFilling.draw(guiGraphics, 0, 0);
        }
        ItemStack output = new ItemStack((ItemLike)(((FluidTransposerRecipe)recipe.value()).getMode() == FluidTransposerBlockEntity.Mode.EMPTYING ? Items.BUCKET : Items.WATER_BUCKET));
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 100.0f);
        guiGraphics.renderItem(output, 120, 5, 835);
        guiGraphics.pose().popPose();
    }

    public void getTooltip(ITooltipBuilder tooltip, RecipeHolder<FluidTransposerRecipe> recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        int tooltipX = 119;
        int tooltipY = 4;
        if (mouseX >= (double)(tooltipX - 1) && mouseX < (double)(tooltipX + 20 + 1) && mouseY >= (double)(tooltipY - 1) && mouseY < (double)(tooltipY + 20 + 1)) {
            tooltip.add((FormattedText)Component.translatable((String)("tooltip.energizedpower.fluid_transposer.mode." + ((FluidTransposerRecipe)recipe.value()).getMode().getSerializedName())));
        }
    }
}

