/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.integration.jei;

import java.util.List;
import java.util.Locale;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.block.EPBlocks;
import me.jddev0.ep.recipe.PulverizerRecipe;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;

public class AdvancedPulverizerCategory
implements IRecipeCategory<RecipeHolder<PulverizerRecipe>> {
    public static final RecipeType<RecipeHolder<PulverizerRecipe>> TYPE = new RecipeType(EPAPI.id("advanced_pulverizer"), RecipeType.createFromVanilla((net.minecraft.world.item.crafting.RecipeType)PulverizerRecipe.Type.INSTANCE).getRecipeClass());
    private final IDrawable background;
    private final IDrawable icon;

    public AdvancedPulverizerCategory(IGuiHelper helper) {
        ResourceLocation texture = EPAPI.id("textures/gui/container/pulverizer.png");
        this.background = helper.createDrawable(texture, 42, 30, 109, 26);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)EPBlocks.ADVANCED_PULVERIZER_ITEM.get()));
    }

    public RecipeType<RecipeHolder<PulverizerRecipe>> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"container.energizedpower.advanced_pulverizer");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder iRecipeLayout, RecipeHolder<PulverizerRecipe> recipe, IFocusGroup iFocusGroup) {
        iRecipeLayout.addSlot(RecipeIngredientRole.INPUT, 1, 5).addIngredients(((PulverizerRecipe)recipe.value()).getInput());
        ItemStack[] outputEntries = ((PulverizerRecipe)recipe.value()).getMaxOutputCounts(true);
        ((IRecipeSlotBuilder)iRecipeLayout.addSlot(RecipeIngredientRole.OUTPUT, 65, 5).addItemStack(outputEntries[0])).addRichTooltipCallback((view, tooltip) -> {
            tooltip.add((FormattedText)Component.translatable((String)"recipes.energizedpower.transfer.output_percentages"));
            double[] percentages = ((PulverizerRecipe)recipe.value()).getOutput().percentagesAdvanced();
            for (int i = 0; i < percentages.length; ++i) {
                tooltip.add((FormattedText)Component.literal((String)String.format(Locale.ENGLISH, "%2d \u2022 %.2f %%", i + 1, 100.0 * percentages[i])));
            }
        });
        ((IRecipeSlotBuilder)iRecipeLayout.addSlot(RecipeIngredientRole.OUTPUT, 92, 5).addItemStacks(outputEntries[1].isEmpty() ? List.of() : List.of(outputEntries[1]))).addRichTooltipCallback((view, tooltip) -> {
            if (view.isEmpty()) {
                return;
            }
            tooltip.add((FormattedText)Component.translatable((String)"recipes.energizedpower.transfer.output_percentages"));
            double[] percentages = ((PulverizerRecipe)recipe.value()).getSecondaryOutput().percentagesAdvanced();
            for (int i = 0; i < percentages.length; ++i) {
                tooltip.add((FormattedText)Component.literal((String)String.format(Locale.ENGLISH, "%2d \u2022 %.2f %%", i + 1, 100.0 * percentages[i])));
            }
        });
    }
}

