/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.integration.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import java.util.Objects;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.block.EPBlocks;
import me.jddev0.ep.block.entity.ChargerBlockEntity;
import me.jddev0.ep.recipe.ChargerRecipe;
import me.jddev0.ep.util.EnergyUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;

public class ChargerEMIRecipe
implements EmiRecipe {
    public static final ResourceLocation SIMPLIFIED_TEXTURE = EPAPI.id("textures/block/charger_side.png");
    public static final EmiStack ITEM = EmiStack.of((ItemLike)((ItemLike)EPBlocks.CHARGER_ITEM.get()));
    public static final EmiRecipeCategory CATEGORY = new EmiRecipeCategory(EPAPI.id("charger"), (EmiRenderable)ITEM, (EmiRenderable)new EmiTexture(SIMPLIFIED_TEXTURE, 0, 0, 16, 16, 16, 16, 16, 16));
    private final ResourceLocation id;
    private final List<EmiIngredient> input;
    private final List<EmiStack> output;
    private final int energyConsumption;

    public ChargerEMIRecipe(RecipeHolder<ChargerRecipe> recipe) {
        this.id = recipe.id();
        this.input = List.of(EmiIngredient.of((Ingredient)((ChargerRecipe)recipe.value()).getInput()));
        this.output = List.of(EmiStack.of((ItemStack)((ChargerRecipe)recipe.value()).getOutput()));
        this.energyConsumption = (int)((float)((ChargerRecipe)recipe.value()).getEnergyConsumption() * ChargerBlockEntity.CHARGER_RECIPE_ENERGY_CONSUMPTION_MULTIPLIER);
    }

    public EmiRecipeCategory getCategory() {
        return CATEGORY;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.input;
    }

    public List<EmiStack> getOutputs() {
        return this.output;
    }

    public int getDisplayWidth() {
        return 113;
    }

    public int getDisplayHeight() {
        return 46;
    }

    public void addWidgets(WidgetHolder widgets) {
        ResourceLocation texture = EPAPI.id("textures/gui/container/charger.png");
        widgets.addTexture(texture, 0, 0, 46, 46, 65, 20);
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 53, 14);
        widgets.addSlot(this.input.get(0), 14, 14).drawBack(false);
        widgets.addSlot((EmiIngredient)this.output.get(0), 91, 14).recipeContext((EmiRecipe)this);
        MutableComponent energyConsumptionText = Component.literal((String)EnergyUtils.getEnergyWithPrefix(this.energyConsumption));
        FormattedCharSequence formattedCharSequence = energyConsumptionText.getVisualOrderText();
        int n = widgets.getWidth() - Minecraft.getInstance().font.width((FormattedText)energyConsumptionText);
        int n2 = widgets.getHeight();
        Objects.requireNonNull(Minecraft.getInstance().font);
        widgets.addText(formattedCharSequence, n, n2 - 9, ChatFormatting.YELLOW.getColor().intValue(), false);
    }
}

