/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.fluid;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class InfinityFluidStorage
implements IFluidHandler {
    protected FluidStack fluid = FluidStack.EMPTY;

    public int getTanks() {
        return 1;
    }

    public FluidStack getFluidInTank(int tank) {
        return this.fluid;
    }

    public int getTankCapacity(int tank) {
        return Integer.MAX_VALUE;
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    public int getCapacity() {
        return Integer.MAX_VALUE;
    }

    public void readFromNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
        this.fluid = FluidStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Fluid"));
    }

    public CompoundTag writeToNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
        if (!this.fluid.isEmpty()) {
            nbt.put("Fluid", this.fluid.save(lookupProvider));
        }
        return nbt;
    }

    public boolean isFluidValid(int tank, FluidStack fluidStack) {
        return true;
    }

    public void setFluid(FluidStack fluid) {
        this.fluid = fluid.isEmpty() ? FluidStack.EMPTY : fluid.copyWithAmount(Integer.MAX_VALUE);
        this.onChange();
    }

    protected void onChange() {
    }

    public int fill(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
        return fluidStack.getAmount();
    }

    public FluidStack drain(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
        return !fluidStack.isEmpty() && FluidStack.isSameFluidSameComponents((FluidStack)fluidStack, (FluidStack)this.fluid) ? this.drain(fluidStack.getAmount(), fluidAction) : FluidStack.EMPTY;
    }

    public FluidStack drain(int amount, IFluidHandler.FluidAction fluidAction) {
        return this.fluid.copyWithAmount(amount);
    }
}

