/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.fluid;

import net.minecraft.core.NonNullList;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class EnergizedPowerFluidStorage
implements IFluidHandler {
    private final NonNullList<FluidStack> fluidStacks;
    private final int[] capacities;

    public EnergizedPowerFluidStorage(int[] capacities) {
        this.fluidStacks = NonNullList.withSize((int)capacities.length, (Object)FluidStack.EMPTY);
        this.capacities = capacities;
    }

    protected void onContentsChanged() {
    }

    public int getTanks() {
        return this.capacities.length;
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        return (FluidStack)this.fluidStacks.get(tank);
    }

    public int getTankCapacity(int tank) {
        return this.capacities[tank];
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return true;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty()) {
            return 0;
        }
        int amountLeft = resource.getAmount();
        int filled = 0;
        for (int i = 0; i < this.getTanks(); ++i) {
            int fluidAmountToAdd;
            if (!this.isFluidValid(i, resource)) continue;
            FluidStack fluid = this.getFluidInTank(i);
            int capacity = this.getTankCapacity(i);
            if (action.simulate()) {
                fluidAmountToAdd = 0;
                if (fluid.isEmpty()) {
                    fluidAmountToAdd = Math.min(capacity, amountLeft);
                } else if (FluidStack.isSameFluidSameComponents((FluidStack)fluid, (FluidStack)resource)) {
                    fluidAmountToAdd = Math.min(capacity - fluid.getAmount(), amountLeft);
                }
                filled += fluidAmountToAdd;
                amountLeft -= fluidAmountToAdd;
                continue;
            }
            if (fluid.isEmpty()) {
                fluidAmountToAdd = Math.min(capacity, amountLeft);
                fluid = new FluidStack(resource.getFluidHolder(), fluidAmountToAdd, resource.getComponentsPatch());
                this.fluidStacks.set(i, (Object)fluid);
                filled += fluidAmountToAdd;
                amountLeft -= fluidAmountToAdd;
                continue;
            }
            if (!FluidStack.isSameFluidSameComponents((FluidStack)fluid, (FluidStack)resource)) continue;
            fluidAmountToAdd = Math.min(capacity - fluid.getAmount(), amountLeft);
            fluid.grow(fluidAmountToAdd);
            filled += fluidAmountToAdd;
            amountLeft -= fluidAmountToAdd;
        }
        if (!action.simulate() && filled > 0) {
            this.onContentsChanged();
        }
        return filled;
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        for (int i = 0; i < this.getTanks(); ++i) {
            FluidStack fluid = this.getFluidInTank(i);
            if (fluid.isEmpty()) continue;
            return this.drain(new FluidStack(fluid.getFluidHolder(), maxDrain, fluid.getComponentsPatch()), action);
        }
        return FluidStack.EMPTY;
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty()) {
            return FluidStack.EMPTY;
        }
        int drainingLeft = resource.getAmount();
        int drained = 0;
        for (int i = 0; i < this.getTanks(); ++i) {
            FluidStack fluid = this.getFluidInTank(i);
            if (!FluidStack.isSameFluidSameComponents((FluidStack)fluid, (FluidStack)resource)) continue;
            int fluidAmountToDrain = Math.min(fluid.getAmount(), drainingLeft);
            if (!action.simulate()) {
                if (fluidAmountToDrain < fluid.getAmount()) {
                    fluid.shrink(fluidAmountToDrain);
                } else {
                    this.fluidStacks.set(i, (Object)FluidStack.EMPTY);
                }
            }
            drained += fluidAmountToDrain;
            drainingLeft -= fluidAmountToDrain;
        }
        if (!action.simulate() && drained > 0) {
            this.onContentsChanged();
        }
        return new FluidStack(resource.getFluidHolder(), drained, resource.getComponentsPatch());
    }

    public FluidStack getFluid(int tank) {
        return (FluidStack)this.fluidStacks.get(tank);
    }

    public void setFluid(int tank, FluidStack fluidStack) {
        this.fluidStacks.set(tank, (Object)fluidStack);
    }

    public int getCapacity(int tank) {
        return this.capacities[tank];
    }

    public void setCapacity(int tank, int capacity) {
        this.capacities[tank] = capacity;
    }
}

