/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.event;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.Optional;
import me.jddev0.ep.block.EPBlocks;
import me.jddev0.ep.item.EPItems;
import me.jddev0.ep.item.EnergizedPowerBookItem;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.OpenEnergizedPowerBookS2CPacket;
import me.jddev0.ep.villager.EPVillager;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;

@EventBusSubscriber(modid="energizedpower")
public class ModEvents {
    @SubscribeEvent
    public static void addCustomTrades(VillagerTradesEvent event) {
        Int2ObjectMap trades = event.getTrades();
        if (event.getType() == EPVillager.ELECTRICIAN_PROFESSION.get()) {
            ModEvents.addOffer((Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, 1, new ItemCost((ItemLike)Items.EMERALD, 6), new ItemCost((ItemLike)Items.BOOK), new ItemStack((ItemLike)EPItems.ENERGIZED_POWER_BOOK.get()), 3, 3, 0.02f);
            ModEvents.addOffer((Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, 1, new ItemCost((ItemLike)Items.COPPER_INGOT, 2), new ItemStack((ItemLike)Items.EMERALD, 1), 25, 1, 0.02f);
            ModEvents.addOffer((Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, 1, new ItemCost((ItemLike)EPItems.SILICON.get(), 3), new ItemStack((ItemLike)Items.EMERALD, 2), 15, 2, 0.02f);
            ModEvents.addOffer((Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, 1, new ItemCost((ItemLike)Items.EMERALD, 6), new ItemStack((ItemLike)EPItems.CABLE_INSULATOR.get(), 16), 5, 3, 0.02f);
            ModEvents.addOffer((Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, 1, new ItemCost((ItemLike)Items.EMERALD, 9), new ItemStack((ItemLike)EPItems.IRON_HAMMER.get()), 2, 3, 0.02f);
            ModEvents.addOffer((Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, 2, new ItemCost((ItemLike)Items.EMERALD, 35), new ItemStack((ItemLike)EPBlocks.COPPER_CABLE_ITEM.get(), 6), 3, 5, 0.02f);
            ModEvents.addOffer((Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, 2, new ItemCost((ItemLike)Items.EMERALD, 6), new ItemCost((ItemLike)Items.COPPER_INGOT, 4), new ItemStack((ItemLike)EPItems.BATTERY_2.get()), 3, 7, 0.02f);
            ModEvents.addOffer((Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, 2, new ItemCost((ItemLike)Items.EMERALD, 6), new ItemCost((ItemLike)Items.COPPER_INGOT, 12), new ItemStack((ItemLike)EPItems.ENERGY_ANALYZER.get()), 2, 8, 0.02f);
            ModEvents.addOffer((Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, 2, new ItemCost((ItemLike)Items.EMERALD, 6), new ItemCost((ItemLike)Items.COPPER_INGOT, 12), new ItemStack((ItemLike)EPItems.FLUID_ANALYZER.get()), 2, 8, 0.02f);
            ModEvents.addOffer((Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, 2, new ItemCost((ItemLike)EPItems.COPPER_PLATE.get(), 3), new ItemStack((ItemLike)Items.EMERALD, 8), 15, 6, 0.02f);
            ModEvents.addOffer((Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, 2, new ItemCost((ItemLike)Items.EMERALD, 12), new ItemStack((ItemLike)EPItems.CUTTER.get()), 2, 8, 0.02f);
            ModEvents.addOffer((Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, 3, new ItemCost((ItemLike)Items.EMERALD, 21), new ItemCost((ItemLike)EPBlocks.BASIC_MACHINE_FRAME_ITEM.get()), new ItemStack((ItemLike)EPBlocks.COAL_ENGINE_ITEM.get()), 3, 10, 0.02f);
            ModEvents.addOffer((Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, 3, new ItemCost((ItemLike)Items.EMERALD, 31), new ItemCost((ItemLike)EPItems.BASIC_SOLAR_CELL.get(), 2), new ItemStack((ItemLike)EPBlocks.SOLAR_PANEL_ITEM_1.get()), 3, 10, 0.02f);
            ModEvents.addOffer((Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, 3, new ItemCost((ItemLike)Items.EMERALD, 33), new ItemCost((ItemLike)EPBlocks.BASIC_MACHINE_FRAME_ITEM.get()), new ItemStack((ItemLike)EPBlocks.FLUID_FILLER_ITEM.get()), 3, 10, 0.02f);
            ModEvents.addOffer((Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, 3, new ItemCost((ItemLike)Items.EMERALD, 38), new ItemCost((ItemLike)EPBlocks.BASIC_MACHINE_FRAME_ITEM.get()), new ItemStack((ItemLike)EPBlocks.AUTO_CRAFTER_ITEM.get()), 3, 10, 0.02f);
            ModEvents.addOffer((Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, 3, new ItemCost((ItemLike)Items.EMERALD, 46), new ItemCost((ItemLike)EPBlocks.BASIC_MACHINE_FRAME_ITEM.get()), new ItemStack((ItemLike)EPBlocks.CHARGER_ITEM.get()), 3, 10, 0.02f);
            ModEvents.addOffer((Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, 3, new ItemCost((ItemLike)EPItems.BASIC_SOLAR_CELL.get(), 3), new ItemStack((ItemLike)Items.EMERALD, 9), 15, 9, 0.02f);
            ModEvents.addOffer((Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, 4, new ItemCost((ItemLike)Items.EMERALD, 34), new ItemCost((ItemLike)EPBlocks.BASIC_MACHINE_FRAME_ITEM.get()), new ItemStack((ItemLike)EPBlocks.SAWMILL_ITEM.get()), 3, 20, 0.02f);
            ModEvents.addOffer((Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, 4, new ItemCost((ItemLike)Items.EMERALD, 39), new ItemCost((ItemLike)EPBlocks.BASIC_MACHINE_FRAME_ITEM.get()), new ItemStack((ItemLike)EPBlocks.CRUSHER_ITEM.get()), 3, 20, 0.02f);
            ModEvents.addOffer((Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, 4, new ItemCost((ItemLike)Items.EMERALD, 52), new ItemCost((ItemLike)EPBlocks.BASIC_MACHINE_FRAME_ITEM.get()), new ItemStack((ItemLike)EPBlocks.COMPRESSOR_ITEM.get()), 3, 20, 0.02f);
            ModEvents.addOffer((Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, 4, new ItemCost((ItemLike)Items.EMERALD, 29), new ItemCost((ItemLike)Items.COPPER_INGOT, 9), new ItemStack((ItemLike)EPItems.BATTERY_4.get()), 2, 19, 0.02f);
            ModEvents.addOffer((Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, 4, new ItemCost((ItemLike)EPItems.SAWDUST.get(), 17), new ItemStack((ItemLike)Items.EMERALD, 4), 20, 18, 0.02f);
            ModEvents.addOffer((Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, 5, new ItemCost((ItemLike)Items.EMERALD, 32), new ItemCost((ItemLike)EPBlocks.HARDENED_MACHINE_FRAME_ITEM.get()), new ItemStack((ItemLike)EPBlocks.THERMAL_GENERATOR_ITEM.get()), 1, 30, 0.02f);
            ModEvents.addOffer((Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, 5, new ItemCost((ItemLike)Items.EMERALD_BLOCK, 9), new ItemCost((ItemLike)EPBlocks.ADVANCED_MACHINE_FRAME_ITEM.get()), new ItemStack((ItemLike)EPBlocks.ENERGIZER_ITEM.get()), 1, 30, 0.02f);
            ModEvents.addOffer((Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, 5, new ItemCost((ItemLike)Items.EMERALD_BLOCK, 12), new ItemCost((ItemLike)EPBlocks.ADVANCED_MACHINE_FRAME_ITEM.get()), new ItemStack((ItemLike)EPBlocks.LIGHTNING_GENERATOR_ITEM.get()), 1, 30, 0.02f);
            ModEvents.addOffer((Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, 5, new ItemCost((ItemLike)EPItems.ENERGIZED_COPPER_INGOT.get()), new ItemStack((ItemLike)Items.EMERALD, 23), 15, 30, 0.02f);
        }
    }

    private static void addOffer(Int2ObjectMap<List<VillagerTrades.ItemListing>> trades, int level, ItemCost cost, ItemStack result, int maxUses, int xp, float priceMultiplier) {
        ModEvents.addOffer(trades, level, cost, null, result, maxUses, xp, priceMultiplier);
    }

    private static void addOffer(Int2ObjectMap<List<VillagerTrades.ItemListing>> trades, int level, ItemCost costA, ItemCost costB, ItemStack result, int maxUses, int xp, float priceMultiplier) {
        ((List)trades.get(level)).add((trader, rand) -> new MerchantOffer(costA, Optional.ofNullable(costB), result, maxUses, xp, priceMultiplier));
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        ModEvents.handlePlayerLecternInteraction(event);
        if (event.isCanceled()) {
            return;
        }
        ModEvents.handlePlayerInWorldCraftingInteract(event);
    }

    private static void handlePlayerLecternInteraction(PlayerInteractEvent.RightClickBlock event) {
        BlockPos blockPos = event.getPos();
        BlockEntity blockEntity = event.getLevel().getBlockEntity(blockPos);
        if (!(blockEntity instanceof LecternBlockEntity)) {
            return;
        }
        LecternBlockEntity lecternBlockEntity = (LecternBlockEntity)blockEntity;
        BlockState blockState = event.getLevel().getBlockState(blockPos);
        if (!((Boolean)blockState.getValue((Property)LecternBlock.HAS_BOOK)).booleanValue()) {
            return;
        }
        ItemStack bookItemStack = lecternBlockEntity.getBook();
        if (!bookItemStack.is((Item)EPItems.ENERGIZED_POWER_BOOK.get())) {
            return;
        }
        Item bookItem = bookItemStack.getItem();
        if (!(bookItem instanceof EnergizedPowerBookItem)) {
            return;
        }
        Player player = event.getEntity();
        if (!event.getLevel().isClientSide) {
            ModMessages.sendToPlayer(new OpenEnergizedPowerBookS2CPacket(blockPos), (ServerPlayer)player);
        }
        event.setCanceled(true);
        event.setCancellationResult(InteractionResult.SUCCESS);
    }

    private static void handlePlayerInWorldCraftingInteract(PlayerInteractEvent.RightClickBlock event) {
        BlockPos blockPos;
        ItemStack itemStack = event.getItemStack();
        if (!itemStack.is(Tags.Items.TOOLS_SHEAR)) {
            return;
        }
        Level level = event.getLevel();
        BlockState blockState = level.getBlockState(blockPos = event.getPos());
        if (!blockState.is(BlockTags.WOOL)) {
            return;
        }
        Player player = event.getEntity();
        if (!event.getLevel().isClientSide) {
            if (!player.isCreative()) {
                itemStack.hurtAndBreak(1, (LivingEntity)player, event.getHand() == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
            }
            level.destroyBlock(blockPos, false, (Entity)player);
            ItemEntity itemEntity = new ItemEntity(level, (double)blockPos.getX() + 0.5, (double)blockPos.getY() + 0.5, (double)blockPos.getZ() + 0.5, new ItemStack((ItemLike)EPItems.CABLE_INSULATOR.get(), 18), 0.0, 0.0, 0.0);
            itemEntity.setPickUpDelay(20);
            level.addFreshEntity((Entity)itemEntity);
            level.playSound(null, blockPos, SoundEvents.SHEEP_SHEAR, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        event.setCanceled(true);
        event.setCancellationResult(InteractionResult.SUCCESS);
    }
}

