/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.entity;

import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public abstract class AbstractMinecartBatteryBox
extends AbstractMinecart
implements Container,
MenuProvider {
    public AbstractMinecartBatteryBox(EntityType<? extends AbstractMinecartBatteryBox> entityType, Level level) {
        super(entityType, level);
    }

    public AbstractMinecartBatteryBox(EntityType<? extends AbstractMinecartBatteryBox> entityType, Level level, double x, double y, double z) {
        super(entityType, level, x, y, z);
    }

    public AbstractMinecart.Type getMinecartType() {
        return AbstractMinecart.Type.CHEST;
    }

    public InteractionResult interact(Player player, InteractionHand interactionHand) {
        player.openMenu((MenuProvider)this);
        return InteractionResult.SUCCESS;
    }

    protected void addAdditionalSaveData(CompoundTag nbt) {
        nbt.putInt("energy", this.getEnergy());
        super.addAdditionalSaveData(nbt);
    }

    protected void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.setEnergy(nbt.getInt("energy"));
    }

    public boolean stillValid(Player player) {
        return !this.isRemoved() && this.position().closerThan((Position)player.position(), 8.0);
    }

    public int getContainerSize() {
        return 0;
    }

    public boolean isEmpty() {
        return true;
    }

    public ItemStack getItem(int slot) {
        return ItemStack.EMPTY;
    }

    public ItemStack removeItem(int slot, int amount) {
        return ItemStack.EMPTY;
    }

    public ItemStack removeItemNoUpdate(int slot) {
        return ItemStack.EMPTY;
    }

    public void setItem(int slot, ItemStack stack) {
    }

    public void setChanged() {
    }

    public void clearContent() {
    }

    public abstract int getCapacity();

    public abstract int getTransferRate();

    public abstract int getEnergy();

    public abstract void setEnergy(int var1);
}

