/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.config.value;

import java.util.ArrayList;
import java.util.List;
import me.jddev0.ep.config.ConfigValidationException;
import me.jddev0.ep.config.ConfigValue;
import me.jddev0.ep.config.validation.ValueValidator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringConfigValue
extends ConfigValue<String> {
    private final int minLen;
    private final boolean minLenCheckEnabled;
    private final int maxLen;
    private final boolean maxLenCheckEnabled;

    public StringConfigValue(@NotNull String key, @NotNull String defaultValue) {
        this(key, (String)null, defaultValue);
    }

    public StringConfigValue(@NotNull String key, @Nullable String comment, @NotNull String defaultValue) {
        this(key, comment, defaultValue, (ValueValidator<? super String>)null);
    }

    public StringConfigValue(@NotNull String key, @Nullable String comment, @NotNull String defaultValue, @Nullable ValueValidator<? super String> customValidator) {
        this(key, comment, defaultValue, customValidator, null, null);
    }

    public StringConfigValue(@NotNull String key, @Nullable String comment, @NotNull String defaultValue, @Nullable Integer minLen, @Nullable Integer maxLen) {
        this(key, comment, defaultValue, null, minLen, maxLen);
    }

    public StringConfigValue(@NotNull String key, @Nullable String comment, @NotNull String defaultValue, @Nullable ValueValidator<? super String> customValidator, @Nullable Integer minLen, @Nullable Integer maxLen) {
        super(key, comment, defaultValue, customValidator);
        this.minLenCheckEnabled = minLen != null;
        this.minLen = this.minLenCheckEnabled ? minLen : 0;
        this.maxLenCheckEnabled = maxLen != null;
        this.maxLen = this.maxLenCheckEnabled ? maxLen : 0;
    }

    @Override
    @NotNull
    public List<String> getValidationCommentLines() {
        ArrayList<String> commentLines = new ArrayList<String>();
        if (this.minLenCheckEnabled) {
            commentLines.add("The value must have at least " + this.minLen + " characters");
        }
        if (this.maxLenCheckEnabled) {
            commentLines.add("The value must have at most " + this.maxLen + " characters");
        }
        commentLines.addAll(super.getValidationCommentLines());
        return commentLines;
    }

    @Override
    public void validate(@NotNull String value) throws ConfigValidationException {
        if (this.minLenCheckEnabled && value.length() < this.minLen) {
            throw new ConfigValidationException("The value must have at least " + this.minLen + " characters");
        }
        if (this.maxLenCheckEnabled && value.length() > this.maxLen) {
            throw new ConfigValidationException("The value must have at most " + this.maxLen + " characters");
        }
        super.validate(value);
    }

    @Override
    @NotNull
    protected String readInternal(@NotNull String rawValue) {
        return rawValue;
    }

    @Override
    @NotNull
    protected String writeInternal(@NotNull String value) {
        return value;
    }
}

