/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.config.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.jddev0.ep.config.ConfigValidationException;
import me.jddev0.ep.config.validation.ValueValidator;
import org.jetbrains.annotations.NotNull;

public class ElementOfCollectionValueValidator<T>
implements ValueValidator<T> {
    private final List<T> elements;

    public ElementOfCollectionValueValidator(Collection<T> elements) {
        this.elements = new ArrayList<T>(elements);
    }

    @Override
    public void validate(@NotNull T value) throws ConfigValidationException {
        if (!this.elements.contains(value)) {
            throw new ConfigValidationException("Value must be one of " + String.valueOf(this.elements));
        }
    }

    @Override
    @NotNull
    public List<String> getValidationCommentLines() {
        return List.of("Value must be one of " + String.valueOf(this.elements));
    }
}

