/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity.base;

import java.util.Optional;
import me.jddev0.ep.block.entity.base.ConfigurableUpgradableInventoryFluidEnergyStorageBlockEntity;
import me.jddev0.ep.block.entity.base.FluidStorageMethods;
import me.jddev0.ep.energy.ReceiveOnlyEnergyStorage;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public abstract class WorkerFluidMachineBlockEntity<F extends IFluidHandler, W>
extends ConfigurableUpgradableInventoryFluidEnergyStorageBlockEntity<ReceiveOnlyEnergyStorage, ItemStackHandler, F> {
    protected final int baseEnergyConsumptionPerTick;
    protected final int baseWorkDuration;
    protected int progress;
    protected int maxProgress;
    protected int energyConsumptionLeft = -1;
    protected boolean hasEnoughEnergy;

    public WorkerFluidMachineBlockEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState, String machineName, int slotCount, int baseWorkDuration, int baseEnergyCapacity, int baseEnergyTransferRate, int baseEnergyConsumptionPerTick, FluidStorageMethods<F> fluidStorageMethods, int baseTankCapacity, UpgradeModuleModifier ... upgradeModifierSlots) {
        super(type, blockPos, blockState, machineName, baseEnergyCapacity, baseEnergyTransferRate, slotCount, fluidStorageMethods, baseTankCapacity, upgradeModifierSlots);
        this.baseEnergyConsumptionPerTick = baseEnergyConsumptionPerTick;
        this.baseWorkDuration = baseWorkDuration;
    }

    @Override
    protected ReceiveOnlyEnergyStorage initEnergyStorage() {
        return new ReceiveOnlyEnergyStorage(0, this.baseEnergyCapacity, this.baseEnergyTransferRate){

            @Override
            public int getCapacity() {
                return Math.max(1, (int)Math.ceil((double)this.capacity * WorkerFluidMachineBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CAPACITY)));
            }

            @Override
            public int getMaxReceive() {
                return Math.max(1, (int)Math.ceil((double)this.maxReceive * WorkerFluidMachineBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_TRANSFER_RATE)));
            }

            @Override
            protected void onChange() {
                WorkerFluidMachineBlockEntity.this.setChanged();
                WorkerFluidMachineBlockEntity.this.syncEnergyToPlayers(32);
            }
        };
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        nbt.put("recipe.progress", (Tag)IntTag.valueOf((int)this.progress));
        nbt.put("recipe.max_progress", (Tag)IntTag.valueOf((int)this.maxProgress));
        nbt.put("recipe.energy_consumption_left", (Tag)IntTag.valueOf((int)this.energyConsumptionLeft));
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.progress = nbt.getInt("recipe.progress");
        this.maxProgress = nbt.getInt("recipe.max_progress");
        this.energyConsumptionLeft = nbt.getInt("recipe.energy_consumption_left");
    }

    public static <F extends IFluidHandler, W> void tick(Level level, BlockPos blockPos, BlockState state, WorkerFluidMachineBlockEntity<F, W> blockEntity) {
        if (level.isClientSide) {
            return;
        }
        blockEntity.onTickStart();
        if (!blockEntity.redstoneMode.isActive((Boolean)state.getValue((Property)BlockStateProperties.POWERED))) {
            return;
        }
        if (blockEntity.hasWork()) {
            Optional<W> workData = blockEntity.getCurrentWorkData();
            if (workData.isEmpty()) {
                blockEntity.onTickEnd();
                return;
            }
            if (blockEntity.maxProgress == 0) {
                blockEntity.onWorkStarted(workData.get());
                blockEntity.maxProgress = blockEntity.getWorkDurationFor(workData.get());
            }
            int energyConsumptionPerTick = blockEntity.getEnergyConsumptionFor(workData.get());
            if (blockEntity.energyConsumptionLeft < 0) {
                blockEntity.energyConsumptionLeft = energyConsumptionPerTick * blockEntity.maxProgress;
            }
            if (energyConsumptionPerTick <= ((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getEnergy()) {
                blockEntity.hasEnoughEnergy = true;
                blockEntity.onHasEnoughEnergy();
                if (blockEntity.progress < 0 || blockEntity.maxProgress < 0 || blockEntity.energyConsumptionLeft < 0) {
                    blockEntity.resetProgress();
                    WorkerFluidMachineBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)state);
                    blockEntity.onTickEnd();
                    return;
                }
                ((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).setEnergy(((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getEnergy() - energyConsumptionPerTick);
                blockEntity.energyConsumptionLeft -= energyConsumptionPerTick;
                ++blockEntity.progress;
                if (blockEntity.progress >= blockEntity.maxProgress) {
                    blockEntity.onWorkCompleted(workData.get());
                }
                WorkerFluidMachineBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)state);
            } else {
                blockEntity.hasEnoughEnergy = false;
                blockEntity.onHasNotEnoughEnergy();
                WorkerFluidMachineBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)state);
            }
        } else {
            blockEntity.resetProgress();
            blockEntity.onHasNotEnoughEnergy();
            WorkerFluidMachineBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)state);
        }
        blockEntity.onTickEnd();
    }

    protected void onTickStart() {
    }

    protected void onTickEnd() {
    }

    protected void onHasEnoughEnergy() {
    }

    protected void onHasNotEnoughEnergy() {
    }

    protected final int getWorkDurationFor(W workData) {
        return Math.max(1, (int)Math.ceil((double)this.baseWorkDuration * this.getWorkDataDependentWorkDuration(workData) / this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.SPEED)));
    }

    protected final int getEnergyConsumptionFor(W workData) {
        return Math.max(1, (int)Math.ceil((double)this.baseEnergyConsumptionPerTick * this.getWorkDataDependentEnergyConsumption(workData) * this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CONSUMPTION)));
    }

    protected double getWorkDataDependentWorkDuration(W workData) {
        return 1.0;
    }

    protected double getWorkDataDependentEnergyConsumption(W workData) {
        return 1.0;
    }

    protected abstract boolean hasWork();

    protected abstract Optional<W> getCurrentWorkData();

    protected abstract void onWorkStarted(W var1);

    protected abstract void onWorkCompleted(W var1);

    protected void resetProgress() {
        this.progress = 0;
        this.maxProgress = 0;
        this.energyConsumptionLeft = -1;
        this.hasEnoughEnergy = false;
    }

    @Override
    protected void updateUpgradeModules() {
        this.resetProgress();
        super.updateUpgradeModules();
    }
}

