/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity.base;

import me.jddev0.ep.block.entity.base.MenuEnergyStorageBlockEntity;
import me.jddev0.ep.energy.IEnergizedPowerEnergyStorage;
import me.jddev0.ep.inventory.upgrade.UpgradeModuleInventory;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.Containers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public abstract class UpgradableEnergyStorageBlockEntity<E extends IEnergizedPowerEnergyStorage>
extends MenuEnergyStorageBlockEntity<E> {
    protected final UpgradeModuleInventory upgradeModuleInventory;
    protected final ContainerListener updateUpgradeModuleListener = container -> this.updateUpgradeModules();

    public UpgradableEnergyStorageBlockEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState, String machineName, int baseEnergyCapacity, int baseEnergyTransferRate, UpgradeModuleModifier ... upgradeModifierSlots) {
        super(type, blockPos, blockState, machineName, baseEnergyCapacity, baseEnergyTransferRate);
        this.upgradeModuleInventory = new UpgradeModuleInventory(upgradeModifierSlots);
        this.upgradeModuleInventory.addListener(this.updateUpgradeModuleListener);
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        nbt.put("upgrade_module_inventory", this.upgradeModuleInventory.saveToNBT(registries));
        super.saveAdditional(nbt, registries);
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        this.upgradeModuleInventory.removeListener(this.updateUpgradeModuleListener);
        this.upgradeModuleInventory.loadFromNBT(nbt.getCompound("upgrade_module_inventory"), registries);
        this.upgradeModuleInventory.addListener(this.updateUpgradeModuleListener);
        super.loadAdditional(nbt, registries);
    }

    public void drops(Level level, BlockPos worldPosition) {
        Containers.dropContents((Level)level, (BlockPos)worldPosition, (Container)this.upgradeModuleInventory);
    }

    protected void updateUpgradeModules() {
        this.setChanged();
        this.syncEnergyToPlayers(32);
    }
}

