/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity.base;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import me.jddev0.ep.block.entity.base.FluidStorageMethods;
import me.jddev0.ep.block.entity.base.UpgradableMenuProvider;
import me.jddev0.ep.block.entity.base.WorkerFluidMachineBlockEntity;
import me.jddev0.ep.inventory.CombinedContainerData;
import me.jddev0.ep.inventory.data.BooleanValueContainerData;
import me.jddev0.ep.inventory.data.ComparatorModeValueContainerData;
import me.jddev0.ep.inventory.data.EnergyValueContainerData;
import me.jddev0.ep.inventory.data.ProgressValueContainerData;
import me.jddev0.ep.inventory.data.RedstoneModeValueContainerData;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.SyncCurrentRecipeS2CPacket;
import me.jddev0.ep.recipe.ChangeCurrentRecipeIndexPacketUpdate;
import me.jddev0.ep.recipe.CurrentRecipePacketUpdate;
import me.jddev0.ep.recipe.SetCurrentRecipeIdPacketUpdate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SelectableRecipeFluidMachineBlockEntity<F extends IFluidHandler, C extends RecipeInput, R extends Recipe<C>>
extends WorkerFluidMachineBlockEntity<F, RecipeHolder<R>>
implements ChangeCurrentRecipeIndexPacketUpdate,
CurrentRecipePacketUpdate<R>,
SetCurrentRecipeIdPacketUpdate {
    protected final UpgradableMenuProvider menuProvider;
    protected final RecipeType<R> recipeType;
    protected final RecipeSerializer<R> recipeSerializer;
    protected ResourceLocation currentRecipeIdForLoad;
    protected RecipeHolder<R> currentRecipe;

    public SelectableRecipeFluidMachineBlockEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState, String machineName, UpgradableMenuProvider menuProvider, int slotCount, RecipeType<R> recipeType, RecipeSerializer<R> recipeSerializer, int baseRecipeDuration, int baseEnergyCapacity, int baseEnergyTransferRate, int baseEnergyConsumptionPerTick, FluidStorageMethods<F> fluidStorageMethods, int baseTankCapacity, UpgradeModuleModifier ... upgradeModifierSlots) {
        super(type, blockPos, blockState, machineName, slotCount, baseRecipeDuration, baseEnergyCapacity, baseEnergyTransferRate, baseEnergyConsumptionPerTick, fluidStorageMethods, baseTankCapacity, upgradeModifierSlots);
        this.menuProvider = menuProvider;
        this.recipeType = recipeType;
        this.recipeSerializer = recipeSerializer;
    }

    @Override
    protected ContainerData initContainerData() {
        return new CombinedContainerData(new ProgressValueContainerData(() -> this.progress, value -> {
            this.progress = value;
        }), new ProgressValueContainerData(() -> this.maxProgress, value -> {
            this.maxProgress = value;
        }), new EnergyValueContainerData(() -> this.hasWork() ? this.getCurrentWorkData().map(this::getEnergyConsumptionFor).orElse(-1) : -1, value -> {}), new EnergyValueContainerData(() -> this.energyConsumptionLeft, value -> {}), new BooleanValueContainerData(() -> this.hasEnoughEnergy, value -> {}), new RedstoneModeValueContainerData(() -> this.redstoneMode, value -> {
            this.redstoneMode = value;
        }), new ComparatorModeValueContainerData(() -> this.comparatorMode, value -> {
            this.comparatorMode = value;
        }));
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        if (this.currentRecipe != null) {
            nbt.put("recipe.id", (Tag)StringTag.valueOf((String)this.currentRecipe.id().toString()));
        }
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        if (nbt.contains("recipe.id")) {
            this.currentRecipeIdForLoad = ResourceLocation.tryParse((String)nbt.getString("recipe.id"));
        }
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        this.syncEnergyToPlayer(player);
        this.syncFluidToPlayer(player);
        this.syncCurrentRecipeToPlayer(player);
        return this.menuProvider.createMenu(id, inventory, this, this.upgradeModuleInventory, this.data);
    }

    @Override
    protected final void onTickStart() {
        if (this.currentRecipeIdForLoad != null) {
            List recipes = this.level.getRecipeManager().getAllRecipesFor(this.recipeType);
            this.currentRecipe = recipes.stream().filter(recipe -> recipe.id().equals((Object)this.currentRecipeIdForLoad)).findFirst().orElse(null);
            this.currentRecipeIdForLoad = null;
        }
    }

    @Override
    protected Optional<RecipeHolder<R>> getCurrentWorkData() {
        return Optional.ofNullable(this.currentRecipe);
    }

    @Override
    protected final double getWorkDataDependentWorkDuration(RecipeHolder<R> workData) {
        return this.getRecipeDependentRecipeDuration(workData);
    }

    protected double getRecipeDependentRecipeDuration(RecipeHolder<R> recipe) {
        return 1.0;
    }

    @Override
    protected final double getWorkDataDependentEnergyConsumption(RecipeHolder<R> workData) {
        return this.getRecipeDependentEnergyConsumption(workData);
    }

    protected double getRecipeDependentEnergyConsumption(RecipeHolder<R> recipe) {
        return 1.0;
    }

    @Override
    protected final boolean hasWork() {
        return this.hasRecipe();
    }

    protected boolean hasRecipe() {
        if (this.level == null || this.currentRecipe == null) {
            return false;
        }
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        return this.canCraftRecipe(inventory, this.currentRecipe);
    }

    @Override
    protected final void onWorkStarted(RecipeHolder<R> workData) {
        this.onStartCrafting(workData);
    }

    protected void onStartCrafting(RecipeHolder<R> recipe) {
    }

    @Override
    protected final void onWorkCompleted(RecipeHolder<R> workData) {
        this.craftItem(workData);
    }

    protected abstract void craftItem(RecipeHolder<R> var1);

    protected abstract boolean canCraftRecipe(SimpleContainer var1, RecipeHolder<R> var2);

    @Override
    public void changeRecipeIndex(boolean downUp) {
        if (this.level == null || this.level.isClientSide()) {
            return;
        }
        List<RecipeHolder> recipes = this.level.getRecipeManager().getAllRecipesFor(this.recipeType);
        recipes = recipes.stream().sorted(Comparator.comparing(recipe -> recipe.value().getResultItem((HolderLookup.Provider)this.level.registryAccess()).getDescriptionId())).toList();
        int currentIndex = -1;
        if (this.currentRecipe != null) {
            for (int i = 0; i < recipes.size(); ++i) {
                if (!this.currentRecipe.id().equals((Object)recipes.get(i).id())) continue;
                currentIndex = i;
                break;
            }
        }
        if ((currentIndex += downUp ? 1 : -1) < -1) {
            currentIndex = recipes.size() - 1;
        } else if (currentIndex >= recipes.size()) {
            currentIndex = -1;
        }
        this.currentRecipe = currentIndex == -1 ? null : recipes.get(currentIndex);
        this.resetProgress();
        this.setChanged();
        this.syncCurrentRecipeToPlayers(32);
    }

    @Override
    public void setRecipeId(ResourceLocation recipeId) {
        if (this.level == null || this.level.isClientSide()) {
            return;
        }
        if (recipeId == null) {
            this.currentRecipe = null;
        } else {
            List recipes = this.level.getRecipeManager().getAllRecipesFor(this.recipeType);
            Optional<RecipeHolder> recipe = recipes.stream().filter(r -> r.id().equals((Object)recipeId)).findFirst();
            this.currentRecipe = recipe.orElse(null);
        }
        this.resetProgress();
        this.setChanged();
        this.syncCurrentRecipeToPlayers(32);
    }

    protected final void syncCurrentRecipeToPlayer(Player player) {
        ModMessages.sendToPlayer(new SyncCurrentRecipeS2CPacket<R>(this.getBlockPos(), this.recipeSerializer, this.currentRecipe), (ServerPlayer)player);
    }

    protected final void syncCurrentRecipeToPlayers(int distance) {
        if (this.level != null && !this.level.isClientSide()) {
            ModMessages.sendToPlayersWithinXBlocks(new SyncCurrentRecipeS2CPacket<R>(this.getBlockPos(), this.recipeSerializer, this.currentRecipe), this.getBlockPos(), (ServerLevel)this.level, distance);
        }
    }

    @Nullable
    public RecipeHolder<R> getCurrentRecipe() {
        return this.currentRecipe;
    }

    @Override
    public void setCurrentRecipe(@Nullable RecipeHolder<R> currentRecipe) {
        this.currentRecipe = currentRecipe;
    }
}

