/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.FluidStorageSingleTankMethods;
import me.jddev0.ep.block.entity.base.SimpleRecipeFluidMachineBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.recipe.ContainerRecipeInputWrapper;
import me.jddev0.ep.recipe.EPRecipes;
import me.jddev0.ep.recipe.StoneLiquefierRecipe;
import me.jddev0.ep.screen.StoneLiquefierMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StoneLiquefierBlockEntity
extends SimpleRecipeFluidMachineBlockEntity<FluidTank, RecipeInput, StoneLiquefierRecipe> {
    public static final int TANK_CAPACITY = 1000 * ModConfigs.COMMON_STONE_LIQUEFIER_TANK_CAPACITY.getValue();
    private final IItemHandler itemHandlerSided;

    public StoneLiquefierBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(EPBlockEntities.STONE_LIQUEFIER_ENTITY.get(), blockPos, blockState, "stone_liquefier", StoneLiquefierMenu::new, 1, EPRecipes.STONE_LIQUEFIER_TYPE.get(), (int)ModConfigs.COMMON_STONE_LIQUEFIER_RECIPE_DURATION.getValue(), (int)ModConfigs.COMMON_STONE_LIQUEFIER_CAPACITY.getValue(), ModConfigs.COMMON_STONE_LIQUEFIER_TRANSFER_RATE.getValue(), (int)ModConfigs.COMMON_STONE_LIQUEFIER_ENERGY_CONSUMPTION_PER_TICK.getValue(), FluidStorageSingleTankMethods.INSTANCE, TANK_CAPACITY, UpgradeModuleModifier.SPEED, UpgradeModuleModifier.ENERGY_CONSUMPTION, UpgradeModuleModifier.ENERGY_CAPACITY);
        this.itemHandlerSided = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 0, i -> false);
    }

    @Override
    protected ItemStackHandler initInventoryStorage() {
        return new ItemStackHandler(this.slotCount){

            protected void onContentsChanged(int slot) {
                StoneLiquefierBlockEntity.this.setChanged();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return switch (slot) {
                    case 0 -> {
                        if (StoneLiquefierBlockEntity.this.level == null || StoneLiquefierBlockEntity.this.level.getRecipeManager().getAllRecipesFor(StoneLiquefierBlockEntity.this.recipeType).stream().map(RecipeHolder::value).map(StoneLiquefierRecipe::getInput).anyMatch(ingredient -> ingredient.test(stack))) {
                            yield true;
                        }
                        yield false;
                    }
                    default -> super.isItemValid(slot, stack);
                };
            }

            public void setStackInSlot(int slot, @NotNull ItemStack stack) {
                if (slot == 0) {
                    ItemStack itemStack = this.getStackInSlot(slot);
                    if (!(StoneLiquefierBlockEntity.this.level == null || stack.isEmpty() || itemStack.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)itemStack))) {
                        StoneLiquefierBlockEntity.this.resetProgress();
                    }
                }
                super.setStackInSlot(slot, stack);
            }
        };
    }

    @Override
    protected FluidTank initFluidStorage() {
        return new FluidTank(this.baseTankCapacity){

            protected void onContentsChanged() {
                StoneLiquefierBlockEntity.this.setChanged();
                StoneLiquefierBlockEntity.this.syncFluidToPlayers(32);
            }

            public boolean isFluidValid(FluidStack stack) {
                if (!super.isFluidValid(stack) || StoneLiquefierBlockEntity.this.level == null) {
                    return false;
                }
                return StoneLiquefierBlockEntity.this.level.getRecipeManager().getAllRecipesFor(StoneLiquefierBlockEntity.this.recipeType).stream().map(RecipeHolder::value).map(StoneLiquefierRecipe::getOutput).anyMatch(fluidStack -> FluidStack.isSameFluidSameComponents((FluidStack)stack, (FluidStack)fluidStack));
            }
        };
    }

    @Nullable
    public IItemHandler getItemHandlerCapability(@Nullable Direction side) {
        if (side == null) {
            return this.itemHandler;
        }
        return this.itemHandlerSided;
    }

    @Nullable
    public IFluidHandler getFluidHandlerCapability(@Nullable Direction side) {
        return this.fluidStorage;
    }

    @Nullable
    public IEnergyStorage getEnergyStorageCapability(@Nullable Direction side) {
        return this.energyStorage;
    }

    @Override
    protected RecipeInput getRecipeInput(Container inventory) {
        return new ContainerRecipeInputWrapper(inventory);
    }

    @Override
    protected void craftItem(RecipeHolder<StoneLiquefierRecipe> recipe) {
        if (this.level == null || !this.hasRecipe()) {
            return;
        }
        FluidStack output = ((StoneLiquefierRecipe)recipe.value()).getOutput().copyWithAmount(((StoneLiquefierRecipe)recipe.value()).getOutput().getAmount());
        ((FluidTank)this.fluidStorage).fill(output, IFluidHandler.FluidAction.EXECUTE);
        this.itemHandler.extractItem(0, 1, false);
        this.resetProgress();
    }

    @Override
    protected boolean canCraftRecipe(SimpleContainer inventory, RecipeHolder<StoneLiquefierRecipe> recipe) {
        int fluidAmountInTank = ((FluidTank)this.fluidStorage).getFluid().getAmount();
        int fluidAmountInRecipe = ((StoneLiquefierRecipe)recipe.value()).getOutput().getAmount();
        return this.level != null && ((FluidTank)this.fluidStorage).getCapacity() - fluidAmountInTank >= fluidAmountInRecipe && (((FluidTank)this.fluidStorage).isEmpty() || FluidStack.isSameFluidSameComponents((FluidStack)((FluidTank)this.fluidStorage).getFluid(), (FluidStack)((StoneLiquefierRecipe)recipe.value()).getOutput()));
    }
}

