/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.SimpleRecipeMachineBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.recipe.ContainerRecipeInputWrapper;
import me.jddev0.ep.recipe.EPRecipes;
import me.jddev0.ep.recipe.SawmillRecipe;
import me.jddev0.ep.screen.SawmillMenu;
import me.jddev0.ep.util.InventoryUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

public class SawmillBlockEntity
extends SimpleRecipeMachineBlockEntity<RecipeInput, SawmillRecipe> {
    private final IItemHandler itemHandlerSided;

    public SawmillBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(EPBlockEntities.SAWMILL_ENTITY.get(), blockPos, blockState, "sawmill", SawmillMenu::new, 3, EPRecipes.SAWMILL_TYPE.get(), (int)ModConfigs.COMMON_SAWMILL_RECIPE_DURATION.getValue(), (int)ModConfigs.COMMON_SAWMILL_CAPACITY.getValue(), ModConfigs.COMMON_SAWMILL_TRANSFER_RATE.getValue(), ModConfigs.COMMON_SAWMILL_ENERGY_CONSUMPTION_PER_TICK.getValue(), UpgradeModuleModifier.SPEED, UpgradeModuleModifier.ENERGY_CONSUMPTION, UpgradeModuleModifier.ENERGY_CAPACITY);
        this.itemHandlerSided = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 0, i -> i == 1 || i == 2);
    }

    @Nullable
    public IItemHandler getItemHandlerCapability(@Nullable Direction side) {
        if (side == null) {
            return this.itemHandler;
        }
        return this.itemHandlerSided;
    }

    @Nullable
    public IEnergyStorage getEnergyStorageCapability(@Nullable Direction side) {
        return this.energyStorage;
    }

    @Override
    protected RecipeInput getRecipeInput(Container inventory) {
        return new ContainerRecipeInputWrapper(inventory);
    }

    @Override
    protected void craftItem(RecipeHolder<SawmillRecipe> recipe) {
        if (this.level == null || !this.hasRecipe()) {
            return;
        }
        this.itemHandler.extractItem(0, 1, false);
        this.itemHandler.setStackInSlot(1, ((SawmillRecipe)recipe.value()).getResultItem((HolderLookup.Provider)this.level.registryAccess()).copyWithCount(this.itemHandler.getStackInSlot(1).getCount() + ((SawmillRecipe)recipe.value()).getResultItem((HolderLookup.Provider)this.level.registryAccess()).getCount()));
        if (!((SawmillRecipe)recipe.value()).getSecondaryOutput().isEmpty()) {
            this.itemHandler.setStackInSlot(2, ((SawmillRecipe)recipe.value()).getSecondaryOutput().copyWithCount(this.itemHandler.getStackInSlot(2).getCount() + ((SawmillRecipe)recipe.value()).getSecondaryOutput().getCount()));
        }
        this.resetProgress();
    }

    @Override
    protected boolean canCraftRecipe(SimpleContainer inventory, RecipeHolder<SawmillRecipe> recipe) {
        return this.level != null && InventoryUtils.canInsertItemIntoSlot((Container)inventory, 1, ((SawmillRecipe)recipe.value()).getResultItem((HolderLookup.Provider)this.level.registryAccess())) && (((SawmillRecipe)recipe.value()).getSecondaryOutput().isEmpty() || InventoryUtils.canInsertItemIntoSlot((Container)inventory, 2, ((SawmillRecipe)recipe.value()).getSecondaryOutput()));
    }
}

