/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.List;
import java.util.Optional;
import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.WorkerMachineBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.inventory.CombinedContainerData;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.inventory.data.BooleanValueContainerData;
import me.jddev0.ep.inventory.data.ComparatorModeValueContainerData;
import me.jddev0.ep.inventory.data.EnergyValueContainerData;
import me.jddev0.ep.inventory.data.ProgressValueContainerData;
import me.jddev0.ep.inventory.data.RedstoneModeValueContainerData;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.SyncFurnaceRecipeTypeS2CPacket;
import me.jddev0.ep.recipe.FurnaceRecipeTypePacketUpdate;
import me.jddev0.ep.screen.PoweredFurnaceMenu;
import me.jddev0.ep.util.InventoryUtils;
import me.jddev0.ep.util.RecipeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PoweredFurnaceBlockEntity
extends WorkerMachineBlockEntity<RecipeHolder<? extends AbstractCookingRecipe>>
implements FurnaceRecipeTypePacketUpdate {
    private static final List<@NotNull ResourceLocation> RECIPE_BLACKLIST = ModConfigs.COMMON_POWERED_FURNACE_RECIPE_BLACKLIST.getValue();
    public static final float RECIPE_DURATION_MULTIPLIER = ModConfigs.COMMON_POWERED_FURNACE_RECIPE_DURATION_MULTIPLIER.getValue().floatValue();
    private final IItemHandler itemHandlerSided;
    @NotNull
    private RecipeType<? extends AbstractCookingRecipe> recipeType;

    public PoweredFurnaceBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(EPBlockEntities.POWERED_FURNACE_ENTITY.get(), blockPos, blockState, "powered_furnace", 2, 1, (int)ModConfigs.COMMON_POWERED_FURNACE_CAPACITY.getValue(), ModConfigs.COMMON_POWERED_FURNACE_TRANSFER_RATE.getValue(), ModConfigs.COMMON_POWERED_FURNACE_ENERGY_CONSUMPTION_PER_TICK.getValue(), UpgradeModuleModifier.SPEED, UpgradeModuleModifier.ENERGY_CONSUMPTION, UpgradeModuleModifier.ENERGY_CAPACITY, UpgradeModuleModifier.FURNACE_MODE);
        this.itemHandlerSided = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 0, i -> i == 1);
        this.recipeType = RecipeType.SMELTING;
    }

    @Override
    protected ItemStackHandler initInventoryStorage() {
        return new ItemStackHandler(this.slotCount){

            protected void onContentsChanged(int slot) {
                PoweredFurnaceBlockEntity.this.setChanged();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return switch (slot) {
                    case 0 -> {
                        if (PoweredFurnaceBlockEntity.this.level == null || RecipeUtils.isIngredientOfAny(PoweredFurnaceBlockEntity.this.level, PoweredFurnaceBlockEntity.this.getRecipeForFurnaceModeUpgrade(), stack)) {
                            yield true;
                        }
                        yield false;
                    }
                    case 1 -> false;
                    default -> super.isItemValid(slot, stack);
                };
            }

            public void setStackInSlot(int slot, @NotNull ItemStack stack) {
                if (slot == 0) {
                    ItemStack itemStack = this.getStackInSlot(slot);
                    if (!(PoweredFurnaceBlockEntity.this.level == null || stack.isEmpty() || itemStack.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)itemStack))) {
                        PoweredFurnaceBlockEntity.this.resetProgress();
                    }
                }
                super.setStackInSlot(slot, stack);
            }
        };
    }

    @Override
    protected ContainerData initContainerData() {
        return new CombinedContainerData(new ProgressValueContainerData(() -> this.progress, value -> {
            this.progress = value;
        }), new ProgressValueContainerData(() -> this.maxProgress, value -> {
            this.maxProgress = value;
        }), new EnergyValueContainerData(() -> this.hasWork() ? this.getCurrentWorkData().map(x$0 -> this.getEnergyConsumptionFor(x$0)).orElse(-1) : -1, value -> {}), new EnergyValueContainerData(() -> this.energyConsumptionLeft, value -> {}), new BooleanValueContainerData(() -> this.hasEnoughEnergy, value -> {}), new RedstoneModeValueContainerData(() -> this.redstoneMode, value -> {
            this.redstoneMode = value;
        }), new ComparatorModeValueContainerData(() -> this.comparatorMode, value -> {
            this.comparatorMode = value;
        }));
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        this.syncEnergyToPlayer(player);
        ModMessages.sendToPlayer(new SyncFurnaceRecipeTypeS2CPacket(this.getRecipeForFurnaceModeUpgrade(), this.getBlockPos()), (ServerPlayer)player);
        return new PoweredFurnaceMenu(id, inventory, this, this.upgradeModuleInventory, this.data);
    }

    @Nullable
    public IItemHandler getItemHandlerCapability(@Nullable Direction side) {
        if (side == null) {
            return this.itemHandler;
        }
        return this.itemHandlerSided;
    }

    @Nullable
    public IEnergyStorage getEnergyStorageCapability(@Nullable Direction side) {
        return this.energyStorage;
    }

    @Override
    protected void onHasEnoughEnergy() {
        if (this.level.getBlockState(this.getBlockPos()).hasProperty((Property)BlockStateProperties.LIT) && !((Boolean)this.level.getBlockState(this.getBlockPos()).getValue((Property)BlockStateProperties.LIT)).booleanValue()) {
            this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    @Override
    protected void onHasNotEnoughEnergyWithOffTimeout() {
        if (this.level.getBlockState(this.getBlockPos()).hasProperty((Property)BlockStateProperties.LIT) && ((Boolean)this.level.getBlockState(this.getBlockPos()).getValue((Property)BlockStateProperties.LIT)).booleanValue()) {
            this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    @Override
    protected Optional<RecipeHolder<? extends AbstractCookingRecipe>> getCurrentWorkData() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        return this.getRecipeFor((Container)inventory, this.level);
    }

    @Override
    protected boolean hasWork() {
        return PoweredFurnaceBlockEntity.hasRecipe(this);
    }

    @Override
    protected void onWorkStarted(RecipeHolder<? extends AbstractCookingRecipe> recipe) {
    }

    @Override
    protected void onWorkCompleted(RecipeHolder<? extends AbstractCookingRecipe> workData) {
        PoweredFurnaceBlockEntity.craftItem(this.getBlockPos(), this.getBlockState(), this);
    }

    @Override
    protected double getWorkDataDependentWorkDuration(RecipeHolder<? extends AbstractCookingRecipe> recipe) {
        return (float)((AbstractCookingRecipe)recipe.value()).getCookingTime() * RECIPE_DURATION_MULTIPLIER / 2.0f;
    }

    private static void craftItem(BlockPos blockPos, BlockState state, PoweredFurnaceBlockEntity blockEntity) {
        Level level = blockEntity.level;
        SimpleContainer inventory = new SimpleContainer(blockEntity.itemHandler.getSlots());
        for (int i = 0; i < blockEntity.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, blockEntity.itemHandler.getStackInSlot(i));
        }
        Optional<? extends RecipeHolder<? extends AbstractCookingRecipe>> recipe = blockEntity.getRecipeFor((Container)inventory, level);
        if (!PoweredFurnaceBlockEntity.hasRecipe(blockEntity) || recipe.isEmpty()) {
            return;
        }
        blockEntity.itemHandler.extractItem(0, 1, false);
        blockEntity.itemHandler.setStackInSlot(1, ((AbstractCookingRecipe)recipe.get().value()).getResultItem((HolderLookup.Provider)level.registryAccess()).copyWithCount(blockEntity.itemHandler.getStackInSlot(1).getCount() + ((AbstractCookingRecipe)recipe.get().value()).getResultItem((HolderLookup.Provider)level.registryAccess()).getCount()));
        blockEntity.resetProgress();
    }

    private static boolean hasRecipe(PoweredFurnaceBlockEntity blockEntity) {
        Level level = blockEntity.level;
        SimpleContainer inventory = new SimpleContainer(blockEntity.itemHandler.getSlots());
        for (int i = 0; i < blockEntity.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, blockEntity.itemHandler.getStackInSlot(i));
        }
        Optional<? extends RecipeHolder<? extends AbstractCookingRecipe>> recipe = blockEntity.getRecipeFor((Container)inventory, level);
        return recipe.isPresent() && InventoryUtils.canInsertItemIntoSlot((Container)inventory, 1, ((AbstractCookingRecipe)recipe.get().value()).getResultItem((HolderLookup.Provider)level.registryAccess()));
    }

    private Optional<? extends RecipeHolder<? extends AbstractCookingRecipe>> getRecipeFor(Container container, Level level) {
        return level.getRecipeManager().getAllRecipesFor(this.getRecipeForFurnaceModeUpgrade()).stream().filter(recipe -> !RECIPE_BLACKLIST.contains(recipe.id())).filter(recipe -> ((AbstractCookingRecipe)recipe.value()).matches(new SingleRecipeInput(container.getItem(0)), level)).findFirst();
    }

    public RecipeType<? extends AbstractCookingRecipe> getRecipeForFurnaceModeUpgrade() {
        if (this.level != null && this.level.isClientSide()) {
            return this.recipeType;
        }
        double value = this.upgradeModuleInventory.getUpgradeModuleModifierEffect(3, UpgradeModuleModifier.FURNACE_MODE);
        if (value == 1.0) {
            return RecipeType.BLASTING;
        }
        if (value == 2.0) {
            return RecipeType.SMOKING;
        }
        return RecipeType.SMELTING;
    }

    @Override
    public void setRecipeType(@NotNull RecipeType<? extends AbstractCookingRecipe> recipeType) {
        this.recipeType = recipeType;
    }

    @Override
    protected void updateUpgradeModules() {
        super.updateUpgradeModules();
        if (this.level != null && !this.level.isClientSide()) {
            ModMessages.sendToPlayersWithinXBlocks(new SyncFurnaceRecipeTypeS2CPacket(this.getRecipeForFurnaceModeUpgrade(), this.getBlockPos()), this.getBlockPos(), (ServerLevel)this.level, 32);
        }
    }
}

