/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import me.jddev0.ep.block.entity.base.MenuInventoryStorageBlockEntity;
import me.jddev0.ep.inventory.CombinedContainerData;
import me.jddev0.ep.inventory.SingleItemStackHandler;
import me.jddev0.ep.inventory.data.IntegerValueContainerData;
import me.jddev0.ep.machine.tier.ItemSiloTier;
import me.jddev0.ep.screen.ItemSiloMenu;
import me.jddev0.ep.util.InventoryUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class ItemSiloBlockEntity
extends MenuInventoryStorageBlockEntity<SingleItemStackHandler> {
    private final ItemSiloTier tier;

    public ItemSiloBlockEntity(BlockPos blockPos, BlockState blockState, ItemSiloTier tier) {
        super(tier.getEntityTypeFromTier(), blockPos, blockState, tier.getResourceId(), tier.getItemSiloCapacity());
        this.tier = tier;
    }

    public ItemSiloTier getTier() {
        return this.tier;
    }

    @Override
    protected SingleItemStackHandler initInventoryStorage() {
        return new SingleItemStackHandler(this.slotCount){

            protected void onContentsChanged(int slot) {
                ItemSiloBlockEntity.this.setChanged();
            }
        };
    }

    @Override
    protected ContainerData initContainerData() {
        ContainerData[] containerDataArray = new ContainerData[2];
        containerDataArray[0] = new IntegerValueContainerData(((SingleItemStackHandler)this.itemHandler)::getCount, value -> {});
        containerDataArray[1] = new IntegerValueContainerData(() -> ((SingleItemStackHandler)this.itemHandler).getSlots() * ((SingleItemStackHandler)this.itemHandler).getStack().getMaxStackSize(), value -> {});
        return new CombinedContainerData(containerDataArray);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return new ItemSiloMenu(id, inventory, this, this.data);
    }

    public int getRedstoneOutput() {
        return InventoryUtils.getRedstoneSignalFromItemStackHandler((SingleItemStackHandler)this.itemHandler);
    }

    @Nullable
    public IItemHandler getItemHandlerCapability(@Nullable Direction side) {
        return this.itemHandler;
    }

    @Override
    public void drops(Level level, BlockPos worldPosition) {
        if (level != null) {
            int count;
            ItemStack stack = ((SingleItemStackHandler)this.itemHandler).getStack();
            if (count > 0 && !stack.isEmpty()) {
                int countItem;
                for (count = ((SingleItemStackHandler)this.itemHandler).getCount(); count > 0; count -= countItem) {
                    countItem = Math.min(count, stack.getMaxStackSize());
                    Containers.dropItemStack((Level)level, (double)worldPosition.getX(), (double)worldPosition.getY(), (double)worldPosition.getZ(), (ItemStack)stack.copyWithCount(countItem));
                }
            }
        }
    }
}

