/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import me.jddev0.ep.block.EPBlockStateProperties;
import me.jddev0.ep.block.ItemConveyorBeltBlock;
import me.jddev0.ep.block.ItemConveyorBeltSwitchBlock;
import me.jddev0.ep.block.entity.ItemConveyorBeltBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.machine.tier.ConveyorBeltTier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class ItemConveyorBeltSwitchBlockEntity
extends BlockEntity {
    private final int ticksPerItem;
    private final ConveyorBeltTier tier;

    public ItemConveyorBeltSwitchBlockEntity(BlockPos blockPos, BlockState blockState, ConveyorBeltTier tier) {
        super(tier.getItemConveyorBeltSwitchBlockEntityFromTier(), blockPos, blockState);
        this.tier = tier;
        this.ticksPerItem = switch (tier) {
            default -> throw new MatchException(null, null);
            case ConveyorBeltTier.BASIC -> ModConfigs.COMMON_BASIC_ITEM_CONVEYOR_BELT_SWITCH_TICKS_PER_ITEM.getValue();
            case ConveyorBeltTier.FAST -> ModConfigs.COMMON_FAST_ITEM_CONVEYOR_BELT_SWITCH_TICKS_PER_ITEM.getValue();
            case ConveyorBeltTier.EXPRESS -> ModConfigs.COMMON_EXPRESS_ITEM_CONVEYOR_BELT_SWITCH_TICKS_PER_ITEM.getValue();
        };
    }

    public ConveyorBeltTier getTier() {
        return this.tier;
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, ItemConveyorBeltSwitchBlockEntity blockEntity) {
        if (level.isClientSide) {
            return;
        }
        if (level.getGameTime() % (long)blockEntity.ticksPerItem == 0L) {
            Direction facing = (Direction)state.getValue((Property)ItemConveyorBeltSwitchBlock.FACING);
            BlockPos inputPos = blockPos.relative(facing);
            BlockState inputBlockState = level.getBlockState(inputPos);
            if (!(inputBlockState.getBlock() instanceof ItemConveyorBeltBlock)) {
                return;
            }
            EPBlockStateProperties.ConveyorBeltDirection inputBeltFacing = (EPBlockStateProperties.ConveyorBeltDirection)((Object)inputBlockState.getValue(ItemConveyorBeltBlock.FACING));
            if (inputBeltFacing.isAscending() || inputBeltFacing.getDirection().getOpposite() != facing) {
                return;
            }
            BlockEntity inputBlockEntity = level.getBlockEntity(inputPos);
            if (!(inputBlockEntity instanceof ItemConveyorBeltBlockEntity)) {
                return;
            }
            IItemHandler inputBeltItemStackStorage = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, inputPos, inputBlockState, inputBlockEntity, (Object)facing.getOpposite());
            if (inputBeltItemStackStorage == null) {
                return;
            }
            ItemStack itemStackToSwitch = inputBeltItemStackStorage.getStackInSlot(inputBeltItemStackStorage.getSlots() - 1);
            if (itemStackToSwitch.isEmpty()) {
                return;
            }
            boolean isPowered = (Boolean)state.getValue((Property)ItemConveyorBeltSwitchBlock.POWERED);
            Direction outputDirection = isPowered ? facing.getCounterClockWise() : facing.getClockWise();
            BlockPos outputPos = blockPos.relative(outputDirection);
            BlockState outputBlockState = level.getBlockState(outputPos);
            if (!(outputBlockState.getBlock() instanceof ItemConveyorBeltBlock)) {
                return;
            }
            BlockEntity outputBlockEntity = level.getBlockEntity(outputPos);
            if (!(outputBlockEntity instanceof ItemConveyorBeltBlockEntity)) {
                return;
            }
            IItemHandler outputBeltItemStackStorage = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, outputPos, outputBlockState, outputBlockEntity, (Object)outputDirection.getOpposite());
            if (outputBeltItemStackStorage == null) {
                return;
            }
            for (int i = 0; i < outputBeltItemStackStorage.getSlots(); ++i) {
                if (!outputBeltItemStackStorage.insertItem(i, itemStackToSwitch, false).isEmpty()) continue;
                inputBeltItemStackStorage.extractItem(inputBeltItemStackStorage.getSlots() - 1, 1, false);
                return;
            }
        }
    }
}

