/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.Arrays;
import me.jddev0.ep.block.InductionSmelterBlock;
import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.SimpleRecipeMachineBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.recipe.AlloyFurnaceRecipe;
import me.jddev0.ep.recipe.ContainerRecipeInputWrapper;
import me.jddev0.ep.recipe.EPRecipes;
import me.jddev0.ep.recipe.IngredientWithCount;
import me.jddev0.ep.screen.InductionSmelterMenu;
import me.jddev0.ep.util.InventoryUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InductionSmelterBlockEntity
extends SimpleRecipeMachineBlockEntity<RecipeInput, AlloyFurnaceRecipe> {
    public static final float RECIPE_DURATION_MULTIPLIER = ModConfigs.COMMON_INDUCTION_SMELTER_RECIPE_DURATION_MULTIPLIER.getValue().floatValue();
    private final IItemHandler itemHandlerSidedFrontTopBottom;
    private final IItemHandler itemHandlerSidedBack;
    private final IItemHandler itemHandlerSidedLeft;
    private final IItemHandler itemHandlerSidedRight;

    public InductionSmelterBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(EPBlockEntities.INDUCTION_SMELTER_ENTITY.get(), blockPos, blockState, "induction_smelter", InductionSmelterMenu::new, 5, EPRecipes.ALLOY_FURNACE_TYPE.get(), 1, (int)ModConfigs.COMMON_INDUCTION_SMELTER_CAPACITY.getValue(), ModConfigs.COMMON_INDUCTION_SMELTER_TRANSFER_RATE.getValue(), ModConfigs.COMMON_INDUCTION_SMELTER_ENERGY_CONSUMPTION_PER_TICK.getValue(), UpgradeModuleModifier.SPEED, UpgradeModuleModifier.ENERGY_CONSUMPTION, UpgradeModuleModifier.ENERGY_CAPACITY);
        this.itemHandlerSidedFrontTopBottom = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i >= 0 && i < 3, i -> i > 2 && i < 5);
        this.itemHandlerSidedBack = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 1, i -> i > 2 && i < 5);
        this.itemHandlerSidedLeft = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 0, i -> i > 2 && i < 5);
        this.itemHandlerSidedRight = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 2, i -> i > 2 && i < 5);
    }

    @Override
    protected ItemStackHandler initInventoryStorage() {
        return new ItemStackHandler(this.slotCount){

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return switch (slot) {
                    case 0, 1, 2 -> {
                        if (InductionSmelterBlockEntity.this.level == null || InductionSmelterBlockEntity.this.level.getRecipeManager().getAllRecipesFor((RecipeType)AlloyFurnaceRecipe.Type.INSTANCE).stream().map(RecipeHolder::value).map(AlloyFurnaceRecipe::getInputs).anyMatch(inputs -> Arrays.stream(inputs).map(IngredientWithCount::input).anyMatch(ingredient -> ingredient.test(stack)))) {
                            yield true;
                        }
                        yield false;
                    }
                    case 3, 4 -> false;
                    default -> false;
                };
            }

            public void setStackInSlot(int slot, @NotNull ItemStack stack) {
                if (slot >= 0 && slot < 3) {
                    ItemStack itemStack = this.getStackInSlot(slot);
                    if (!(InductionSmelterBlockEntity.this.level == null || stack.isEmpty() || itemStack.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)itemStack))) {
                        InductionSmelterBlockEntity.this.resetProgress();
                    }
                }
                super.setStackInSlot(slot, stack);
            }

            protected void onContentsChanged(int slot) {
                InductionSmelterBlockEntity.this.setChanged();
            }
        };
    }

    @Nullable
    public IItemHandler getItemHandlerCapability(@Nullable Direction side) {
        if (side == null) {
            return this.itemHandler;
        }
        Direction facing = (Direction)this.getBlockState().getValue((Property)InductionSmelterBlock.FACING);
        if (facing.getOpposite() == side) {
            return this.itemHandlerSidedBack;
        }
        if (facing.getClockWise() == side) {
            return this.itemHandlerSidedLeft;
        }
        if (facing.getCounterClockWise() == side) {
            return this.itemHandlerSidedRight;
        }
        return this.itemHandlerSidedFrontTopBottom;
    }

    @Nullable
    public IEnergyStorage getEnergyStorageCapability(@Nullable Direction side) {
        return this.energyStorage;
    }

    @Override
    protected void onHasEnoughEnergy() {
        if (this.level.getBlockState(this.getBlockPos()).hasProperty((Property)BlockStateProperties.LIT) && !((Boolean)this.level.getBlockState(this.getBlockPos()).getValue((Property)BlockStateProperties.LIT)).booleanValue()) {
            this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    @Override
    protected void onHasNotEnoughEnergyWithOffTimeout() {
        if (this.level.getBlockState(this.getBlockPos()).hasProperty((Property)BlockStateProperties.LIT) && ((Boolean)this.level.getBlockState(this.getBlockPos()).getValue((Property)BlockStateProperties.LIT)).booleanValue()) {
            this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    @Override
    protected double getRecipeDependentRecipeDuration(RecipeHolder<AlloyFurnaceRecipe> recipe) {
        return (float)((AlloyFurnaceRecipe)recipe.value()).getTicks() * RECIPE_DURATION_MULTIPLIER / 2.0f;
    }

    @Override
    protected RecipeInput getRecipeInput(Container inventory) {
        return new ContainerRecipeInputWrapper(inventory);
    }

    @Override
    protected void craftItem(RecipeHolder<AlloyFurnaceRecipe> recipe) {
        if (this.level == null || !this.hasRecipe()) {
            return;
        }
        IngredientWithCount[] inputs = ((AlloyFurnaceRecipe)recipe.value()).getInputs();
        boolean[] usedIndices = new boolean[3];
        for (int i = 0; i < 3; ++i) {
            usedIndices[i] = this.itemHandler.getStackInSlot(i).isEmpty();
        }
        int len = Math.min(inputs.length, 3);
        for (int i = 0; i < len; ++i) {
            IngredientWithCount input = inputs[i];
            int indexMinCount = -1;
            int minCount = Integer.MAX_VALUE;
            for (int j = 0; j < 3; ++j) {
                if (usedIndices[j]) continue;
                ItemStack item = this.itemHandler.getStackInSlot(j);
                if (indexMinCount != -1 && item.getCount() >= minCount || !input.input().test(item) || item.getCount() < input.count()) continue;
                indexMinCount = j;
                minCount = item.getCount();
            }
            if (indexMinCount == -1) {
                return;
            }
            usedIndices[indexMinCount] = true;
            this.itemHandler.extractItem(indexMinCount, input.count(), false);
        }
        ItemStack[] outputs = ((AlloyFurnaceRecipe)recipe.value()).generateOutputs(this.level.random);
        this.itemHandler.setStackInSlot(3, outputs[0].copyWithCount(this.itemHandler.getStackInSlot(3).getCount() + outputs[0].getCount()));
        if (!outputs[1].isEmpty()) {
            this.itemHandler.setStackInSlot(4, outputs[1].copyWithCount(this.itemHandler.getStackInSlot(4).getCount() + outputs[1].getCount()));
        }
        this.resetProgress();
    }

    @Override
    protected boolean canCraftRecipe(SimpleContainer inventory, RecipeHolder<AlloyFurnaceRecipe> recipe) {
        ItemStack[] maxOutputs = ((AlloyFurnaceRecipe)recipe.value()).getMaxOutputCounts();
        return this.level != null && InventoryUtils.canInsertItemIntoSlot((Container)inventory, 3, maxOutputs[0]) && (maxOutputs[1].isEmpty() || InventoryUtils.canInsertItemIntoSlot((Container)inventory, 4, maxOutputs[1]));
    }
}

