/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import com.mojang.serialization.Codec;
import java.util.Locale;
import java.util.Optional;
import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.FluidStorageSingleTankMethods;
import me.jddev0.ep.block.entity.base.SimpleRecipeFluidMachineBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.inventory.CombinedContainerData;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.inventory.data.BooleanValueContainerData;
import me.jddev0.ep.inventory.data.ComparatorModeValueContainerData;
import me.jddev0.ep.inventory.data.EnergyValueContainerData;
import me.jddev0.ep.inventory.data.ProgressValueContainerData;
import me.jddev0.ep.inventory.data.RedstoneModeValueContainerData;
import me.jddev0.ep.inventory.data.ShortValueContainerData;
import me.jddev0.ep.machine.CheckboxUpdate;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.recipe.ContainerRecipeInputWrapper;
import me.jddev0.ep.recipe.EPRecipes;
import me.jddev0.ep.recipe.FluidTransposerRecipe;
import me.jddev0.ep.screen.FluidTransposerMenu;
import me.jddev0.ep.util.InventoryUtils;
import me.jddev0.ep.util.RecipeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidTransposerBlockEntity
extends SimpleRecipeFluidMachineBlockEntity<FluidTank, RecipeInput, FluidTransposerRecipe>
implements CheckboxUpdate {
    public static final int TANK_CAPACITY = 1000 * ModConfigs.COMMON_FLUID_TRANSPOSER_TANK_CAPACITY.getValue();
    private final IItemHandler itemHandlerSided;
    private Mode mode;

    public FluidTransposerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(EPBlockEntities.FLUID_TRANSPOSER_ENTITY.get(), blockPos, blockState, "fluid_transposer", FluidTransposerMenu::new, 2, EPRecipes.FLUID_TRANSPOSER_TYPE.get(), (int)ModConfigs.COMMON_FLUID_TRANSPOSER_RECIPE_DURATION.getValue(), (int)ModConfigs.COMMON_FLUID_TRANSPOSER_CAPACITY.getValue(), ModConfigs.COMMON_FLUID_TRANSPOSER_TRANSFER_RATE.getValue(), (int)ModConfigs.COMMON_FLUID_TRANSPOSER_ENERGY_CONSUMPTION_PER_TICK.getValue(), FluidStorageSingleTankMethods.INSTANCE, TANK_CAPACITY, UpgradeModuleModifier.SPEED, UpgradeModuleModifier.ENERGY_CONSUMPTION, UpgradeModuleModifier.ENERGY_CAPACITY);
        this.itemHandlerSided = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 0, i -> i == 1);
        this.mode = Mode.EMPTYING;
    }

    @Override
    protected ContainerData initContainerData() {
        return new CombinedContainerData(new ProgressValueContainerData(() -> this.progress, value -> {
            this.progress = value;
        }), new ProgressValueContainerData(() -> this.maxProgress, value -> {
            this.maxProgress = value;
        }), new EnergyValueContainerData(() -> this.hasWork() ? this.getCurrentWorkData().map(x$0 -> this.getEnergyConsumptionFor(x$0)).orElse(-1) : -1, value -> {}), new EnergyValueContainerData(() -> this.energyConsumptionLeft, value -> {}), new BooleanValueContainerData(() -> this.hasEnoughEnergy, value -> {}), new ShortValueContainerData(() -> (short)this.mode.ordinal(), value -> {
            this.mode = Mode.fromIndex(value.shortValue());
        }), new RedstoneModeValueContainerData(() -> this.redstoneMode, value -> {
            this.redstoneMode = value;
        }), new ComparatorModeValueContainerData(() -> this.comparatorMode, value -> {
            this.comparatorMode = value;
        }));
    }

    @Override
    protected ItemStackHandler initInventoryStorage() {
        return new ItemStackHandler(this.slotCount){

            protected void onContentsChanged(int slot) {
                FluidTransposerBlockEntity.this.setChanged();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return switch (slot) {
                    case 0 -> {
                        if (FluidTransposerBlockEntity.this.level == null || RecipeUtils.isIngredientOfAny(FluidTransposerBlockEntity.this.level, FluidTransposerBlockEntity.this.recipeType, stack)) {
                            yield true;
                        }
                        yield false;
                    }
                    case 1 -> false;
                    default -> super.isItemValid(slot, stack);
                };
            }

            public void setStackInSlot(int slot, @NotNull ItemStack stack) {
                if (slot == 0) {
                    ItemStack itemStack = this.getStackInSlot(slot);
                    if (!(FluidTransposerBlockEntity.this.level == null || stack.isEmpty() || itemStack.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)itemStack))) {
                        FluidTransposerBlockEntity.this.resetProgress();
                    }
                }
                super.setStackInSlot(slot, stack);
            }
        };
    }

    @Override
    protected FluidTank initFluidStorage() {
        return new FluidTank(this.baseTankCapacity){

            protected void onContentsChanged() {
                FluidTransposerBlockEntity.this.setChanged();
                FluidTransposerBlockEntity.this.syncFluidToPlayers(32);
            }

            public boolean isFluidValid(FluidStack stack) {
                if (!super.isFluidValid(stack) || FluidTransposerBlockEntity.this.level == null) {
                    return false;
                }
                return FluidTransposerBlockEntity.this.level.getRecipeManager().getAllRecipesFor(FluidTransposerBlockEntity.this.recipeType).stream().map(RecipeHolder::value).map(FluidTransposerRecipe::getFluid).anyMatch(fluidStack -> FluidStack.isSameFluidSameComponents((FluidStack)stack, (FluidStack)fluidStack));
            }
        };
    }

    @Nullable
    public IItemHandler getItemHandlerCapability(@Nullable Direction side) {
        if (side == null) {
            return this.itemHandler;
        }
        return this.itemHandlerSided;
    }

    @Nullable
    public IFluidHandler getFluidHandlerCapability(@Nullable Direction side) {
        return this.fluidStorage;
    }

    @Nullable
    public IEnergyStorage getEnergyStorageCapability(@Nullable Direction side) {
        return this.energyStorage;
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        nbt.putInt("mode", this.mode.ordinal());
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.mode = Mode.fromIndex(nbt.getInt("mode"));
    }

    @Override
    protected Optional<RecipeHolder<FluidTransposerRecipe>> getRecipeFor(Container inventory) {
        return this.level.getRecipeManager().getAllRecipesFor(this.recipeType).stream().filter(recipe -> ((FluidTransposerRecipe)recipe.value()).getMode() == this.mode).filter(recipe -> ((FluidTransposerRecipe)recipe.value()).matches(this.getRecipeInput(inventory), this.level)).filter(recipe -> this.mode == Mode.EMPTYING && ((FluidTank)this.fluidStorage).isEmpty() || FluidStack.isSameFluidSameComponents((FluidStack)((FluidTransposerRecipe)recipe.value()).getFluid(), (FluidStack)((FluidTank)this.fluidStorage).getFluid())).findFirst();
    }

    @Override
    protected RecipeInput getRecipeInput(Container inventory) {
        return new ContainerRecipeInputWrapper(inventory);
    }

    @Override
    protected void craftItem(RecipeHolder<FluidTransposerRecipe> recipe) {
        if (this.level == null || !this.hasRecipe()) {
            return;
        }
        FluidStack fluid = ((FluidTransposerRecipe)recipe.value()).getFluid().copyWithAmount(((FluidTransposerRecipe)recipe.value()).getFluid().getAmount());
        if (this.mode == Mode.EMPTYING) {
            ((FluidTank)this.fluidStorage).fill(fluid, IFluidHandler.FluidAction.EXECUTE);
        } else {
            ((FluidTank)this.fluidStorage).drain(fluid, IFluidHandler.FluidAction.EXECUTE);
        }
        this.itemHandler.extractItem(0, 1, false);
        this.itemHandler.setStackInSlot(1, ((FluidTransposerRecipe)recipe.value()).getResultItem((HolderLookup.Provider)this.level.registryAccess()).copyWithCount(this.itemHandler.getStackInSlot(1).getCount() + ((FluidTransposerRecipe)recipe.value()).getResultItem((HolderLookup.Provider)this.level.registryAccess()).getCount()));
        this.resetProgress();
    }

    @Override
    protected boolean canCraftRecipe(SimpleContainer inventory, RecipeHolder<FluidTransposerRecipe> recipe) {
        int fluidAmountInTank = ((FluidTank)this.fluidStorage).getFluid().getAmount();
        int fluidAmountInRecipe = ((FluidTransposerRecipe)recipe.value()).getFluid().getAmount();
        return this.level != null && (this.mode == Mode.EMPTYING ? ((FluidTank)this.fluidStorage).getCapacity() - fluidAmountInTank : fluidAmountInTank) >= fluidAmountInRecipe && (this.mode != Mode.EMPTYING || ((FluidTank)this.fluidStorage).isEmpty() || FluidStack.isSameFluidSameComponents((FluidStack)((FluidTank)this.fluidStorage).getFluid(), (FluidStack)((FluidTransposerRecipe)recipe.value()).getFluid())) && InventoryUtils.canInsertItemIntoSlot((Container)inventory, 1, ((FluidTransposerRecipe)recipe.value()).getResultItem((HolderLookup.Provider)this.level.registryAccess()));
    }

    public void setMode(boolean isFillingMode) {
        this.mode = isFillingMode ? Mode.FILLING : Mode.EMPTYING;
        this.resetProgress();
        FluidTransposerBlockEntity.setChanged((Level)this.level, (BlockPos)this.getBlockPos(), (BlockState)this.getBlockState());
    }

    @Override
    public void setCheckbox(int checkboxId, boolean checked) {
        switch (checkboxId) {
            case 0: {
                this.setMode(checked);
            }
        }
    }

    public static enum Mode implements StringRepresentable
    {
        EMPTYING,
        FILLING;

        public static final Codec<Mode> CODEC;

        @NotNull
        public static Mode fromIndex(int index) {
            Mode[] values = Mode.values();
            if (index < 0 || index >= values.length) {
                return EMPTYING;
            }
            return values[index];
        }

        @NotNull
        public String getSerializedName() {
            return this.name().toLowerCase(Locale.US);
        }

        static {
            CODEC = ExtraCodecs.orCompressed((Codec)Codec.stringResolver(Enum::name, Mode::valueOf), (Codec)ExtraCodecs.idResolverCodec(Enum::ordinal, i -> i >= 0 && i < Mode.values().length ? Mode.values()[i] : null, (int)-1));
        }
    }
}

