/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import me.jddev0.ep.block.EPBlockStateProperties;
import me.jddev0.ep.block.FluidPipeBlock;
import me.jddev0.ep.machine.tier.FluidPipeTier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidPipeBlockEntity
extends BlockEntity {
    private final FluidPipeTier tier;
    private final int maxTransfer;
    private final IFluidHandler fluidStorage;
    private final Map<Pair<BlockPos, Direction>, IFluidHandler> producers = new HashMap<Pair<BlockPos, Direction>, IFluidHandler>();
    private final Map<Pair<BlockPos, Direction>, IFluidHandler> consumers = new HashMap<Pair<BlockPos, Direction>, IFluidHandler>();
    private final Deque<BlockPos> pipeBlocks = new ArrayDeque<BlockPos>();

    public FluidPipeBlockEntity(BlockPos blockPos, BlockState blockState, FluidPipeTier tier) {
        super(tier.getEntityTypeFromTier(), blockPos, blockState);
        this.tier = tier;
        this.maxTransfer = tier.getTransferRate();
        this.fluidStorage = new IFluidHandler(this){

            public int getTanks() {
                return 0;
            }

            @NotNull
            public FluidStack getFluidInTank(int tank) {
                return FluidStack.EMPTY;
            }

            public int getTankCapacity(int tank) {
                return 0;
            }

            public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
                return false;
            }

            public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
                return 0;
            }

            @NotNull
            public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
                return FluidStack.EMPTY;
            }

            @NotNull
            public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
                return FluidStack.EMPTY;
            }
        };
    }

    public FluidPipeTier getTier() {
        return this.tier;
    }

    public Map<Pair<BlockPos, Direction>, IFluidHandler> getProducers() {
        return this.producers;
    }

    public Map<Pair<BlockPos, Direction>, IFluidHandler> getConsumers() {
        return this.consumers;
    }

    public Deque<BlockPos> getPipeBlocks() {
        return this.pipeBlocks;
    }

    public static void updateConnections(Level level, BlockPos blockPos, BlockState state, FluidPipeBlockEntity blockEntity) {
        if (level.isClientSide) {
            return;
        }
        blockEntity.producers.clear();
        blockEntity.consumers.clear();
        blockEntity.pipeBlocks.clear();
        for (Direction direction : Direction.values()) {
            BlockPos testPos = blockPos.relative(direction);
            BlockEntity testBlockEntity = level.getBlockEntity(testPos);
            if (testBlockEntity instanceof FluidPipeBlockEntity) {
                FluidPipeBlockEntity fluidPipeBlockEntity = (FluidPipeBlockEntity)testBlockEntity;
                if (fluidPipeBlockEntity.getTier() != blockEntity.getTier()) continue;
                blockEntity.pipeBlocks.add(testPos);
                continue;
            }
            IFluidHandler fluidStorage = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, testPos, level.getBlockState(testPos), testBlockEntity, (Object)direction.getOpposite());
            if (fluidStorage == null || fluidStorage.getTanks() == 0) continue;
            EPBlockStateProperties.PipeConnection pipeConnection = (EPBlockStateProperties.PipeConnection)((Object)state.getValue(FluidPipeBlock.getPipeConnectionPropertyFromDirection(direction)));
            if (pipeConnection.isExtract()) {
                blockEntity.producers.put((Pair<BlockPos, Direction>)Pair.of((Object)testPos, (Object)direction.getOpposite()), fluidStorage);
                continue;
            }
            if (!pipeConnection.isInsert()) continue;
            blockEntity.consumers.put((Pair<BlockPos, Direction>)Pair.of((Object)testPos, (Object)direction.getOpposite()), fluidStorage);
        }
    }

    public static Deque<IFluidHandler> getConnectedConsumers(Level level, BlockPos blockPos, Set<BlockPos> checkedPipes) {
        ArrayDeque<IFluidHandler> consumers = new ArrayDeque<IFluidHandler>(1024);
        ArrayDeque<BlockPos> pipeBlocksLeft = new ArrayDeque<BlockPos>(1024);
        pipeBlocksLeft.add(blockPos);
        checkedPipes.add(blockPos);
        while (pipeBlocksLeft.size() > 0) {
            BlockPos checkPos = (BlockPos)pipeBlocksLeft.pop();
            BlockEntity blockEntity = level.getBlockEntity(checkPos);
            if (!(blockEntity instanceof FluidPipeBlockEntity)) continue;
            FluidPipeBlockEntity fluidPipeBlockEntity = (FluidPipeBlockEntity)blockEntity;
            fluidPipeBlockEntity.getPipeBlocks().forEach(pos -> {
                if (checkedPipes.add((BlockPos)pos)) {
                    pipeBlocksLeft.add((BlockPos)pos);
                }
            });
            consumers.addAll(fluidPipeBlockEntity.getConsumers().values());
        }
        return consumers;
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, FluidPipeBlockEntity blockEntity) {
        int realInsert;
        FluidStack realExtract;
        int consumptionSum;
        ArrayList<Integer> fluidConsumptionValues;
        ArrayList<IFluidHandler> fluidConsumption;
        int productionSum;
        ArrayList<Integer> fluidProductionValues;
        FluidStack extractedFluidType;
        ArrayList<IFluidHandler> fluidProduction;
        if (level.isClientSide) {
            return;
        }
        FluidPipeBlockEntity.updateConnections(level, blockPos, state, blockEntity);
        Deque<IFluidHandler> consumers = null;
        ArrayList<FluidStack> alreadyCheckedFluidTypes = new ArrayList<FluidStack>();
        while (true) {
            int i;
            fluidProduction = new ArrayList<IFluidHandler>();
            extractedFluidType = FluidStack.EMPTY;
            fluidProductionValues = new ArrayList<Integer>();
            productionSum = 0;
            for (IFluidHandler fluidStorage : blockEntity.producers.values()) {
                boolean extractedAnything = false;
                int fluidProductionValuesIndex = -1;
                block2: for (i = 0; i < fluidStorage.getTanks(); ++i) {
                    FluidStack fluidStackInTank = fluidStorage.getFluidInTank(i);
                    if (fluidStackInTank.isEmpty()) continue;
                    boolean wasExtractedFluidTypeEmpty = extractedFluidType.isEmpty();
                    if (wasExtractedFluidTypeEmpty) {
                        for (FluidStack alreadyCheckedFluidType : alreadyCheckedFluidTypes) {
                            if (!FluidStack.isSameFluidSameComponents((FluidStack)alreadyCheckedFluidType, (FluidStack)fluidStackInTank)) continue;
                            continue block2;
                        }
                        extractedFluidType = fluidStackInTank.copy();
                        extractedFluidType.setAmount(blockEntity.maxTransfer);
                    }
                    if (!FluidStack.isSameFluidSameComponents((FluidStack)fluidStackInTank, (FluidStack)extractedFluidType)) continue;
                    FluidStack extracted = fluidStorage.drain(extractedFluidType.copy(), IFluidHandler.FluidAction.SIMULATE);
                    if (extracted.getAmount() <= 0 || extracted.isEmpty() || !FluidStack.isSameFluidSameComponents((FluidStack)extracted, (FluidStack)extractedFluidType)) {
                        if (!wasExtractedFluidTypeEmpty) continue;
                        extractedFluidType = FluidStack.EMPTY;
                        continue;
                    }
                    extractedAnything = true;
                    if (fluidProductionValuesIndex == -1) {
                        fluidProductionValuesIndex = fluidProductionValues.size();
                        fluidProductionValues.add(extracted.getAmount());
                    } else {
                        fluidProductionValues.set(fluidProductionValuesIndex, (Integer)fluidProductionValues.get(fluidProductionValuesIndex) + extracted.getAmount());
                    }
                    productionSum += extracted.getAmount();
                }
                if (!extractedAnything) continue;
                fluidProduction.add(fluidStorage);
            }
            if (productionSum <= 0 || extractedFluidType.isEmpty()) {
                return;
            }
            fluidConsumption = new ArrayList<IFluidHandler>();
            fluidConsumptionValues = new ArrayList<Integer>();
            consumptionSum = 0;
            if (consumers == null) {
                consumers = FluidPipeBlockEntity.getConnectedConsumers(level, blockPos, new HashSet<BlockPos>());
            }
            extractedFluidType.setAmount(Math.min(blockEntity.maxTransfer, productionSum));
            for (IFluidHandler fluidStorage : consumers) {
                boolean receivedAnything = false;
                int fluidConsumptionValuesIndex = -1;
                for (i = 0; i < fluidStorage.getTanks(); ++i) {
                    FluidStack extractedFluidTypeTmp = extractedFluidType.copy();
                    int received = fluidStorage.fill(extractedFluidTypeTmp, IFluidHandler.FluidAction.SIMULATE);
                    if (received <= 0) continue;
                    receivedAnything = true;
                    if (fluidConsumptionValuesIndex == -1) {
                        fluidConsumptionValuesIndex = fluidConsumptionValues.size();
                        fluidConsumptionValues.add(received);
                    } else {
                        fluidConsumptionValues.set(fluidConsumptionValuesIndex, (Integer)fluidConsumptionValues.get(fluidConsumptionValuesIndex) + received);
                    }
                    consumptionSum += received;
                }
                if (!receivedAnything) continue;
                fluidConsumption.add(fluidStorage);
            }
            if (consumptionSum > 0) break;
            alreadyCheckedFluidTypes.add(extractedFluidType);
        }
        int transferLeft = Math.min(productionSum, consumptionSum);
        ArrayList<Integer> fluidProductionDistributed = new ArrayList<Integer>();
        for (int i = 0; i < fluidProduction.size(); ++i) {
            fluidProductionDistributed.add(0);
        }
        int productionLeft = transferLeft;
        int divisor = fluidProduction.size();
        block7: while (productionLeft > 0) {
            int productionPerProducer = productionLeft / divisor;
            if (productionPerProducer == 0) {
                divisor = Math.max(1, divisor - 1);
                productionPerProducer = productionLeft / divisor;
            }
            for (int i = 0; i < fluidProductionValues.size(); ++i) {
                int productionDistributed = (Integer)fluidProductionDistributed.get(i);
                int productionOfProducerLeft = (Integer)fluidProductionValues.get(i) - productionDistributed;
                int productionDistributedNew = Math.min(productionPerProducer, Math.min(productionOfProducerLeft, productionLeft));
                fluidProductionDistributed.set(i, productionDistributed + productionDistributedNew);
                if ((productionLeft -= productionDistributedNew) == 0) break block7;
            }
        }
        int realProduction = 0;
        int realProductionAmountMissing = 0;
        for (int i = 0; i < fluidProduction.size(); ++i) {
            int amount = (Integer)fluidProductionDistributed.get(i) + realProductionAmountMissing;
            if (amount <= 0) continue;
            FluidStack extract = extractedFluidType.copy();
            extract.setAmount(amount);
            realExtract = ((IFluidHandler)fluidProduction.get(i)).drain(extract, IFluidHandler.FluidAction.EXECUTE);
            realProduction += realExtract.getAmount();
            realProductionAmountMissing = amount - realExtract.getAmount();
        }
        if (realProductionAmountMissing > 0) {
            for (IFluidHandler producer : fluidProduction) {
                FluidStack extract = extractedFluidType.copy();
                extract.setAmount(realProductionAmountMissing);
                realExtract = producer.drain(extract, IFluidHandler.FluidAction.EXECUTE);
                realProduction += realExtract.getAmount();
                if ((realProductionAmountMissing -= realExtract.getAmount()) != 0) continue;
                break;
            }
        }
        ArrayList<Integer> fluidConsumptionDistributed = new ArrayList<Integer>();
        for (int i = 0; i < fluidConsumption.size(); ++i) {
            fluidConsumptionDistributed.add(0);
        }
        int consumptionLeft = realProduction;
        divisor = fluidConsumption.size();
        block12: while (consumptionLeft > 0) {
            int consumptionPerConsumer = consumptionLeft / divisor;
            if (consumptionPerConsumer == 0) {
                divisor = Math.max(1, divisor - 1);
                consumptionPerConsumer = consumptionLeft / divisor;
            }
            for (int i = 0; i < fluidConsumptionValues.size(); ++i) {
                int consumptionDistributed = (Integer)fluidConsumptionDistributed.get(i);
                int consumptionOfConsumerLeft = (Integer)fluidConsumptionValues.get(i) - consumptionDistributed;
                int consumptionDistributedNew = Math.min(consumptionOfConsumerLeft, Math.min(consumptionPerConsumer, consumptionLeft));
                fluidConsumptionDistributed.set(i, consumptionDistributed + consumptionDistributedNew);
                if ((consumptionLeft -= consumptionDistributedNew) == 0) break block12;
            }
        }
        int realConsumptionAmountMissing = 0;
        for (int i = 0; i < fluidConsumption.size(); ++i) {
            int amount = (Integer)fluidConsumptionDistributed.get(i) + realConsumptionAmountMissing;
            if (amount <= 0) continue;
            FluidStack insert = extractedFluidType.copy();
            insert.setAmount(amount);
            realInsert = ((IFluidHandler)fluidConsumption.get(i)).fill(insert, IFluidHandler.FluidAction.EXECUTE);
            realConsumptionAmountMissing = amount - realInsert;
        }
        if (realConsumptionAmountMissing > 0) {
            for (IFluidHandler consumer : fluidConsumption) {
                FluidStack insert = extractedFluidType.copy();
                insert.setAmount(realConsumptionAmountMissing);
                realInsert = consumer.fill(insert, IFluidHandler.FluidAction.EXECUTE);
                if ((realConsumptionAmountMissing -= realInsert) != 0) continue;
                break;
            }
        }
    }

    @Nullable
    public IFluidHandler getFluidHandlerCapability(@Nullable Direction side) {
        return this.fluidStorage;
    }

    protected void saveAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
    }

    protected void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
    }
}

