/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.FluidStorageSingleTankMethods;
import me.jddev0.ep.block.entity.base.MenuFluidStorageBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.inventory.CombinedContainerData;
import me.jddev0.ep.inventory.data.ProgressValueContainerData;
import me.jddev0.ep.screen.DrainMenu;
import me.jddev0.ep.util.FluidUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DrainBlockEntity
extends MenuFluidStorageBlockEntity<FluidTank> {
    private int progress;
    private int maxProgress = ModConfigs.COMMON_DRAIN_DRAIN_DURATION.getValue();

    public DrainBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(EPBlockEntities.DRAIN_ENTITY.get(), blockPos, blockState, "drain", FluidStorageSingleTankMethods.INSTANCE, ModConfigs.COMMON_DRAIN_FLUID_TANK_CAPACITY.getValue() * 1000);
    }

    @Override
    protected FluidTank initFluidStorage() {
        return new FluidTank(this.baseTankCapacity){

            protected void onContentsChanged() {
                DrainBlockEntity.this.setChanged();
                DrainBlockEntity.this.syncFluidToPlayers(32);
            }
        };
    }

    @Override
    protected ContainerData initContainerData() {
        return new CombinedContainerData(new ProgressValueContainerData(() -> this.progress, value -> {
            this.progress = value;
        }), new ProgressValueContainerData(() -> this.maxProgress, value -> {
            this.maxProgress = value;
        }));
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        this.syncFluidToPlayer(player);
        return new DrainMenu(id, inventory, this, this.data);
    }

    public int getRedstoneOutput() {
        return FluidUtils.getRedstoneSignalFromFluidHandler(this.fluidStorage);
    }

    @Nullable
    public IFluidHandler getFluidHandlerCapability(@Nullable Direction side) {
        return this.fluidStorage;
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        nbt.put("drain.progress", (Tag)IntTag.valueOf((int)this.progress));
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.progress = nbt.getInt("drain.progress");
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, DrainBlockEntity blockEntity) {
        if (level.isClientSide) {
            return;
        }
        if (DrainBlockEntity.hasRecipe(blockEntity)) {
            if (blockEntity.progress < 0 || blockEntity.maxProgress < 0) {
                blockEntity.resetProgress(blockPos, state);
                DrainBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)state);
                return;
            }
            if (blockEntity.progress < blockEntity.maxProgress) {
                ++blockEntity.progress;
            }
            if (blockEntity.progress >= blockEntity.maxProgress) {
                BucketPickup aboveBlock;
                ItemStack bucketItemStack;
                BlockPos aboveBlockPos = blockPos.above();
                BlockState aboveBlockState = level.getBlockState(aboveBlockPos);
                Block block = aboveBlockState.getBlock();
                if (block instanceof BucketPickup && !(bucketItemStack = (aboveBlock = (BucketPickup)block).pickupBlock(null, (LevelAccessor)level, aboveBlockPos, aboveBlockState)).isEmpty()) {
                    FluidStack fluidStack;
                    level.gameEvent(null, (Holder)GameEvent.FLUID_PICKUP, aboveBlockPos);
                    IFluidHandlerItem fluidStorage = (IFluidHandlerItem)bucketItemStack.getCapability(Capabilities.FluidHandler.ITEM);
                    if (fluidStorage != null && fluidStorage.getTanks() == 1 && !(fluidStack = fluidStorage.getFluidInTank(0)).isEmpty()) {
                        ((FluidTank)blockEntity.fluidStorage).fill(fluidStack.copy(), IFluidHandler.FluidAction.EXECUTE);
                    }
                }
                blockEntity.resetProgress(blockPos, state);
            }
            DrainBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)state);
        } else {
            blockEntity.resetProgress(blockPos, state);
            DrainBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)state);
        }
    }

    private void resetProgress(BlockPos blockPos, BlockState state) {
        this.progress = 0;
    }

    private static boolean hasRecipe(DrainBlockEntity blockEntity) {
        BlockPos blockPos;
        BlockPos aboveBlockPos;
        Level level = blockEntity.getLevel();
        BlockState aboveBlockState = level.getBlockState(aboveBlockPos = (blockPos = blockEntity.getBlockPos()).above());
        if (!(aboveBlockState.getBlock() instanceof BucketPickup)) {
            return false;
        }
        FluidState fluidState = level.getFluidState(aboveBlockPos);
        if (fluidState.isEmpty()) {
            return false;
        }
        return ((FluidTank)blockEntity.fluidStorage).fill(new FluidStack(fluidState.getType(), 1000), IFluidHandler.FluidAction.SIMULATE) == 1000;
    }
}

