/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.Optional;
import me.jddev0.ep.block.ChargerBlock;
import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.ConfigurableUpgradableInventoryEnergyStorageBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.ReceiveOnlyEnergyStorage;
import me.jddev0.ep.inventory.CombinedContainerData;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.inventory.data.ComparatorModeValueContainerData;
import me.jddev0.ep.inventory.data.EnergyValueContainerData;
import me.jddev0.ep.inventory.data.RedstoneModeValueContainerData;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.recipe.ChargerRecipe;
import me.jddev0.ep.recipe.ContainerRecipeInputWrapper;
import me.jddev0.ep.screen.ChargerMenu;
import me.jddev0.ep.util.RecipeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChargerBlockEntity
extends ConfigurableUpgradableInventoryEnergyStorageBlockEntity<ReceiveOnlyEnergyStorage, ItemStackHandler> {
    public static final float CHARGER_RECIPE_ENERGY_CONSUMPTION_MULTIPLIER = ModConfigs.COMMON_CHARGER_CHARGER_RECIPE_ENERGY_CONSUMPTION_MULTIPLIER.getValue().floatValue();
    private final IItemHandler itemHandlerSided;
    private int energyConsumptionLeft;

    public ChargerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(EPBlockEntities.CHARGER_ENTITY.get(), blockPos, blockState, "charger", ModConfigs.COMMON_CHARGER_CAPACITY.getValue(), ModConfigs.COMMON_CHARGER_TRANSFER_RATE.getValue(), 1, UpgradeModuleModifier.ENERGY_CAPACITY);
        this.itemHandlerSided = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> true, i -> {
            if (i != 0) {
                return false;
            }
            ItemStack stack = this.itemHandler.getStackInSlot(i.intValue());
            if (this.level != null && RecipeUtils.isResultOfAny(this.level, ChargerRecipe.Type.INSTANCE, stack)) {
                return true;
            }
            if (this.level == null || RecipeUtils.isIngredientOfAny(this.level, ChargerRecipe.Type.INSTANCE, stack)) {
                return false;
            }
            IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
            if (energyStorage == null || !energyStorage.canReceive()) {
                return true;
            }
            return energyStorage.receiveEnergy(((ReceiveOnlyEnergyStorage)this.energyStorage).getMaxReceive(), true) == 0;
        });
        this.energyConsumptionLeft = -1;
    }

    @Override
    protected ReceiveOnlyEnergyStorage initEnergyStorage() {
        return new ReceiveOnlyEnergyStorage(0, this.baseEnergyCapacity, this.baseEnergyTransferRate){

            @Override
            public int getCapacity() {
                return Math.max(1, (int)Math.ceil((double)this.capacity * ChargerBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CAPACITY)));
            }

            @Override
            public int getMaxReceive() {
                return Math.max(1, (int)Math.ceil((double)this.maxReceive * ChargerBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_TRANSFER_RATE)));
            }

            @Override
            protected void onChange() {
                ChargerBlockEntity.this.setChanged();
                ChargerBlockEntity.this.syncEnergyToPlayers(32);
            }
        };
    }

    @Override
    protected ItemStackHandler initInventoryStorage() {
        return new ItemStackHandler(this.slotCount){

            protected void onContentsChanged(int slot) {
                ChargerBlockEntity.this.setChanged();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                if (slot == 0) {
                    if (ChargerBlockEntity.this.level == null || RecipeUtils.isIngredientOfAny(ChargerBlockEntity.this.level, ChargerRecipe.Type.INSTANCE, stack)) {
                        return true;
                    }
                    IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
                    return energyStorage != null && energyStorage.canReceive();
                }
                return super.isItemValid(slot, stack);
            }

            public void setStackInSlot(int slot, @NotNull ItemStack stack) {
                if (slot == 0) {
                    ItemStack itemStack = this.getStackInSlot(slot);
                    if (!(ChargerBlockEntity.this.level == null || stack.isEmpty() || itemStack.isEmpty() || ItemStack.isSameItem((ItemStack)stack, (ItemStack)itemStack) && (ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)itemStack) || stack.getCapability(Capabilities.EnergyStorage.ITEM) != null && itemStack.getCapability(Capabilities.EnergyStorage.ITEM) != null))) {
                        ChargerBlockEntity.this.resetProgress();
                    }
                }
                super.setStackInSlot(slot, stack);
            }

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
    }

    @Override
    protected ContainerData initContainerData() {
        return new CombinedContainerData(new EnergyValueContainerData(() -> this.hasRecipe() ? this.getEnergyConsumptionPerTick() : -1, value -> {}), new EnergyValueContainerData(() -> this.energyConsumptionLeft, value -> {}), new RedstoneModeValueContainerData(() -> this.redstoneMode, value -> {
            this.redstoneMode = value;
        }), new ComparatorModeValueContainerData(() -> this.comparatorMode, value -> {
            this.comparatorMode = value;
        }));
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        this.syncEnergyToPlayer(player);
        return new ChargerMenu(id, inventory, this, this.upgradeModuleInventory, this.data);
    }

    @Nullable
    public IItemHandler getItemHandlerCapability(@Nullable Direction side) {
        if (side == null) {
            return this.itemHandler;
        }
        return this.itemHandlerSided;
    }

    @Nullable
    public IEnergyStorage getEnergyStorageCapability(@Nullable Direction side) {
        return this.energyStorage;
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        nbt.put("recipe.energy_consumption_left", (Tag)IntTag.valueOf((int)this.energyConsumptionLeft));
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.energyConsumptionLeft = nbt.getInt("recipe.energy_consumption_left");
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, ChargerBlockEntity blockEntity) {
        if (level.isClientSide) {
            return;
        }
        if (!blockEntity.redstoneMode.isActive((Boolean)state.getValue((Property)ChargerBlock.POWERED))) {
            return;
        }
        if (blockEntity.hasRecipe()) {
            int energyConsumptionPerTick;
            ItemStack stack = blockEntity.itemHandler.getStackInSlot(0);
            SimpleContainer inventory = new SimpleContainer(blockEntity.itemHandler.getSlots());
            for (int i = 0; i < blockEntity.itemHandler.getSlots(); ++i) {
                inventory.setItem(i, blockEntity.itemHandler.getStackInSlot(i));
            }
            Optional recipe = level.getRecipeManager().getRecipeFor((RecipeType)ChargerRecipe.Type.INSTANCE, (RecipeInput)new ContainerRecipeInputWrapper((Container)inventory), level);
            if (recipe.isPresent()) {
                if (blockEntity.energyConsumptionLeft == -1) {
                    blockEntity.energyConsumptionLeft = (int)((float)((ChargerRecipe)((RecipeHolder)recipe.get()).value()).getEnergyConsumption() * CHARGER_RECIPE_ENERGY_CONSUMPTION_MULTIPLIER);
                }
                if (((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getEnergy() == 0) {
                    ChargerBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)state);
                    return;
                }
                energyConsumptionPerTick = Math.min(blockEntity.energyConsumptionLeft, Math.min(((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getMaxReceive(), ((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getEnergy()));
            } else {
                IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
                if (energyStorage == null || !energyStorage.canReceive()) {
                    return;
                }
                blockEntity.energyConsumptionLeft = Math.max(0, energyStorage.getMaxEnergyStored() - energyStorage.getEnergyStored());
                if (((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getEnergy() == 0) {
                    ChargerBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)state);
                    return;
                }
                energyConsumptionPerTick = energyStorage.receiveEnergy(Math.min(((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getMaxReceive(), ((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getEnergy()), false);
            }
            if (blockEntity.energyConsumptionLeft < 0 || energyConsumptionPerTick < 0) {
                blockEntity.resetProgress();
                ChargerBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)state);
                return;
            }
            ((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).setEnergy(((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getEnergy() - energyConsumptionPerTick);
            blockEntity.energyConsumptionLeft -= energyConsumptionPerTick;
            if (blockEntity.energyConsumptionLeft <= 0) {
                recipe.ifPresent(chargerRecipe -> blockEntity.itemHandler.setStackInSlot(0, ((ChargerRecipe)chargerRecipe.value()).getResultItem((HolderLookup.Provider)level.registryAccess()).copyWithCount(1)));
                blockEntity.resetProgress();
            }
            ChargerBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)state);
        } else {
            blockEntity.resetProgress();
            ChargerBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)state);
        }
    }

    protected final int getEnergyConsumptionPerTick() {
        if (this.level == null) {
            return -1;
        }
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        Optional recipe = this.level.getRecipeManager().getRecipeFor((RecipeType)ChargerRecipe.Type.INSTANCE, (RecipeInput)new ContainerRecipeInputWrapper((Container)inventory), this.level);
        if (recipe.isPresent()) {
            return Math.min(this.energyConsumptionLeft, Math.min(((ReceiveOnlyEnergyStorage)this.energyStorage).getMaxReceive(), ((ReceiveOnlyEnergyStorage)this.energyStorage).getEnergy()));
        }
        IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (energyStorage == null || !energyStorage.canReceive()) {
            return -1;
        }
        return energyStorage.receiveEnergy(Math.min(((ReceiveOnlyEnergyStorage)this.energyStorage).getMaxReceive(), ((ReceiveOnlyEnergyStorage)this.energyStorage).getEnergy()), true);
    }

    private void resetProgress() {
        this.energyConsumptionLeft = -1;
    }

    private boolean hasRecipe() {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (stack.getCapability(Capabilities.EnergyStorage.ITEM) != null) {
            return true;
        }
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        Optional recipe = this.level.getRecipeManager().getRecipeFor((RecipeType)ChargerRecipe.Type.INSTANCE, (RecipeInput)new ContainerRecipeInputWrapper((Container)inventory), this.level);
        return recipe.isPresent();
    }

    @Override
    protected void updateUpgradeModules() {
        this.resetProgress();
        super.updateUpgradeModules();
    }
}

