/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import me.jddev0.ep.block.CableBlock;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.ReceiveOnlyEnergyStorage;
import me.jddev0.ep.machine.tier.CableTier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CableBlockEntity
extends BlockEntity {
    private static final CableBlock.EnergyExtractionMode ENERGY_EXTRACTION_MODE = ModConfigs.COMMON_CABLES_ENERGY_EXTRACTION_MODE.getValue();
    private final CableTier tier;
    private final ReceiveOnlyEnergyStorage energyStorage;
    private boolean loaded;
    private final Map<Pair<BlockPos, Direction>, IEnergyStorage> producers = new HashMap<Pair<BlockPos, Direction>, IEnergyStorage>();
    private final Map<Pair<BlockPos, Direction>, IEnergyStorage> consumers = new HashMap<Pair<BlockPos, Direction>, IEnergyStorage>();
    private final Deque<BlockPos> cableBlocks = new ArrayDeque<BlockPos>();

    public CableBlockEntity(BlockPos blockPos, BlockState blockState, CableTier tier) {
        super(tier.getEntityTypeFromTier(), blockPos, blockState);
        this.tier = tier;
        this.energyStorage = ENERGY_EXTRACTION_MODE.isPush() ? new ReceiveOnlyEnergyStorage(0, tier.getMaxTransfer(), tier.getMaxTransfer()){

            @Override
            protected void onChange() {
                CableBlockEntity.this.setChanged();
            }
        } : new ReceiveOnlyEnergyStorage(this){

            @Override
            public int receiveEnergy(int maxReceive, boolean simulate) {
                return 0;
            }

            @Override
            public boolean canReceive() {
                return false;
            }
        };
    }

    public CableTier getTier() {
        return this.tier;
    }

    public Map<Pair<BlockPos, Direction>, IEnergyStorage> getProducers() {
        return this.producers;
    }

    public Map<Pair<BlockPos, Direction>, IEnergyStorage> getConsumers() {
        return this.consumers;
    }

    public Deque<BlockPos> getCableBlocks() {
        return this.cableBlocks;
    }

    public static void updateConnections(Level level, BlockPos blockPos, BlockState state, CableBlockEntity blockEntity) {
        if (level.isClientSide) {
            return;
        }
        blockEntity.producers.clear();
        blockEntity.consumers.clear();
        blockEntity.cableBlocks.clear();
        for (Direction direction : Direction.values()) {
            BlockPos testPos = blockPos.relative(direction);
            BlockEntity testBlockEntity = level.getBlockEntity(testPos);
            if (testBlockEntity instanceof CableBlockEntity) {
                CableBlockEntity cableBlockEntity = (CableBlockEntity)testBlockEntity;
                if (cableBlockEntity.getTier() != blockEntity.getTier()) continue;
                blockEntity.cableBlocks.add(testPos);
                continue;
            }
            IEnergyStorage energyStorage = (IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, testPos, level.getBlockState(testPos), testBlockEntity, (Object)direction.getOpposite());
            if (energyStorage == null) continue;
            if (ENERGY_EXTRACTION_MODE.isPull() && energyStorage.canExtract()) {
                blockEntity.producers.put((Pair<BlockPos, Direction>)Pair.of((Object)testPos, (Object)direction.getOpposite()), energyStorage);
            }
            if (!energyStorage.canReceive()) continue;
            blockEntity.consumers.put((Pair<BlockPos, Direction>)Pair.of((Object)testPos, (Object)direction.getOpposite()), energyStorage);
        }
    }

    public static Deque<IEnergyStorage> getConnectedConsumers(Level level, BlockPos blockPos, Set<BlockPos> checkedCables) {
        ArrayDeque<IEnergyStorage> consumers = new ArrayDeque<IEnergyStorage>(1024);
        ArrayDeque<BlockPos> cableBlocksLeft = new ArrayDeque<BlockPos>(1024);
        cableBlocksLeft.add(blockPos);
        checkedCables.add(blockPos);
        while (cableBlocksLeft.size() > 0) {
            BlockPos checkPos = (BlockPos)cableBlocksLeft.pop();
            BlockEntity blockEntity = level.getBlockEntity(checkPos);
            if (!(blockEntity instanceof CableBlockEntity)) continue;
            CableBlockEntity cableBlockEntity = (CableBlockEntity)blockEntity;
            cableBlockEntity.getCableBlocks().forEach(pos -> {
                if (checkedCables.add((BlockPos)pos)) {
                    cableBlocksLeft.add((BlockPos)pos);
                }
            });
            consumers.addAll(cableBlockEntity.getConsumers().values());
        }
        return consumers;
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, CableBlockEntity blockEntity) {
        int i;
        if (level.isClientSide) {
            return;
        }
        if (!blockEntity.loaded) {
            CableBlockEntity.updateConnections(level, blockPos, state, blockEntity);
            blockEntity.loaded = true;
        }
        int MAX_TRANSFER = blockEntity.tier.getMaxTransfer();
        ArrayList<IEnergyStorage> energyProduction = new ArrayList<IEnergyStorage>();
        ArrayList<Integer> energyProductionValues = new ArrayList<Integer>();
        int productionSum = blockEntity.energyStorage.getEnergy();
        for (IEnergyStorage energyStorage : blockEntity.producers.values()) {
            int extracted = energyStorage.extractEnergy(MAX_TRANSFER, true);
            if (extracted <= 0) continue;
            energyProduction.add(energyStorage);
            energyProductionValues.add(extracted);
            productionSum += extracted;
        }
        if (productionSum <= 0) {
            return;
        }
        ArrayList<IEnergyStorage> energyConsumption = new ArrayList<IEnergyStorage>();
        ArrayList<Integer> energyConsumptionValues = new ArrayList<Integer>();
        Deque<IEnergyStorage> consumers = CableBlockEntity.getConnectedConsumers(level, blockPos, new HashSet<BlockPos>());
        int consumptionSum = 0;
        for (IEnergyStorage energyStorage : consumers) {
            int received = energyStorage.receiveEnergy(MAX_TRANSFER, true);
            if (received <= 0) continue;
            energyConsumption.add(energyStorage);
            energyConsumptionValues.add(received);
            consumptionSum += received;
        }
        if (consumptionSum <= 0) {
            return;
        }
        int transferLeft = Math.min(Math.min(MAX_TRANSFER, productionSum), consumptionSum);
        int extractInternally = 0;
        if (ENERGY_EXTRACTION_MODE.isPush()) {
            extractInternally = Math.min(blockEntity.energyStorage.getEnergy(), transferLeft);
            blockEntity.energyStorage.setEnergy(blockEntity.energyStorage.getEnergy() - extractInternally);
        }
        ArrayList<Integer> energyProductionDistributed = new ArrayList<Integer>();
        for (int i2 = 0; i2 < energyProduction.size(); ++i2) {
            energyProductionDistributed.add(0);
        }
        int productionLeft = ENERGY_EXTRACTION_MODE.isPull() ? transferLeft - extractInternally : 0;
        int divisor = energyProduction.size();
        block3: while (productionLeft > 0) {
            int productionPerProducer = productionLeft / divisor;
            if (productionPerProducer == 0) {
                divisor = Math.max(1, divisor - 1);
                productionPerProducer = productionLeft / divisor;
            }
            for (i = 0; i < energyProductionValues.size(); ++i) {
                int productionDistributed = (Integer)energyProductionDistributed.get(i);
                int productionOfProducerLeft = (Integer)energyProductionValues.get(i) - productionDistributed;
                int productionDistributedNew = Math.min(productionPerProducer, Math.min(productionOfProducerLeft, productionLeft));
                energyProductionDistributed.set(i, productionDistributed + productionDistributedNew);
                if ((productionLeft -= productionDistributedNew) == 0) break block3;
            }
        }
        for (int i3 = 0; i3 < energyProduction.size(); ++i3) {
            int energy = (Integer)energyProductionDistributed.get(i3);
            if (energy <= 0) continue;
            ((IEnergyStorage)energyProduction.get(i3)).extractEnergy(energy, false);
        }
        ArrayList<Integer> energyConsumptionDistributed = new ArrayList<Integer>();
        for (i = 0; i < energyConsumption.size(); ++i) {
            energyConsumptionDistributed.add(0);
        }
        int consumptionLeft = transferLeft;
        divisor = energyConsumption.size();
        block7: while (consumptionLeft > 0) {
            int consumptionPerConsumer = consumptionLeft / divisor;
            if (consumptionPerConsumer == 0) {
                divisor = Math.max(1, divisor - 1);
                consumptionPerConsumer = consumptionLeft / divisor;
            }
            for (int i4 = 0; i4 < energyConsumptionValues.size(); ++i4) {
                int consumptionDistributed = (Integer)energyConsumptionDistributed.get(i4);
                int consumptionOfConsumerLeft = (Integer)energyConsumptionValues.get(i4) - consumptionDistributed;
                int consumptionDistributedNew = Math.min(consumptionOfConsumerLeft, Math.min(consumptionPerConsumer, consumptionLeft));
                energyConsumptionDistributed.set(i4, consumptionDistributed + consumptionDistributedNew);
                if ((consumptionLeft -= consumptionDistributedNew) == 0) break block7;
            }
        }
        for (int i5 = 0; i5 < energyConsumption.size(); ++i5) {
            int energy = (Integer)energyConsumptionDistributed.get(i5);
            if (energy <= 0) continue;
            ((IEnergyStorage)energyConsumption.get(i5)).receiveEnergy(energy, false);
        }
    }

    @Nullable
    public IEnergyStorage getEnergyStorageCapability(@Nullable Direction side) {
        return this.energyStorage;
    }

    protected void saveAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        if (ENERGY_EXTRACTION_MODE.isPush()) {
            nbt.put("energy", this.energyStorage.saveNBT());
        }
    }

    protected void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        if (ENERGY_EXTRACTION_MODE.isPush()) {
            this.energyStorage.loadNBT(nbt.get("energy"));
        }
    }
}

