/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import me.jddev0.ep.block.AutoCrafterBlock;
import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.ConfigurableUpgradableInventoryEnergyStorageBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.ReceiveOnlyEnergyStorage;
import me.jddev0.ep.inventory.CombinedContainerData;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.inventory.data.BooleanValueContainerData;
import me.jddev0.ep.inventory.data.ComparatorModeValueContainerData;
import me.jddev0.ep.inventory.data.EnergyValueContainerData;
import me.jddev0.ep.inventory.data.ProgressValueContainerData;
import me.jddev0.ep.inventory.data.RedstoneModeValueContainerData;
import me.jddev0.ep.machine.CheckboxUpdate;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.screen.AutoCrafterMenu;
import me.jddev0.ep.util.ItemStackUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutoCrafterBlockEntity
extends ConfigurableUpgradableInventoryEnergyStorageBlockEntity<ReceiveOnlyEnergyStorage, ItemStackHandler>
implements CheckboxUpdate {
    private static final List<@NotNull ResourceLocation> RECIPE_BLACKLIST = ModConfigs.COMMON_AUTO_CRAFTER_RECIPE_BLACKLIST.getValue();
    public static final int ENERGY_CONSUMPTION_PER_TICK_PER_INGREDIENT = ModConfigs.COMMON_AUTO_CRAFTER_ENERGY_CONSUMPTION_PER_TICK_PER_INGREDIENT.getValue();
    public static final int RECIPE_DURATION = ModConfigs.COMMON_AUTO_CRAFTER_RECIPE_DURATION.getValue();
    private boolean secondaryExtractMode;
    private boolean allowOutputOverflow = true;
    private final IItemHandler itemHandlerSided = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i >= 3, i -> this.secondaryExtractMode ? !this.isInput(this.itemHandler.getStackInSlot(i.intValue())) : this.isOutputOrCraftingRemainderOfInput(this.itemHandler.getStackInSlot(i.intValue())));
    private final SimpleContainer patternSlots = new SimpleContainer(this, 9){

        public int getMaxStackSize() {
            return 1;
        }
    };
    private final SimpleContainer patternResultSlots = new SimpleContainer(1);
    private final ContainerListener updatePatternListener = container -> this.updateRecipe();
    private boolean hasRecipeLoaded = false;
    private ResourceLocation recipeIdForSetRecipe;
    private RecipeHolder<CraftingRecipe> craftingRecipe;
    private CraftingContainer oldCopyOfRecipe;
    private final AbstractContainerMenu dummyContainerMenu = new AbstractContainerMenu(this, null, -1){

        public ItemStack quickMoveStack(Player player, int index) {
            return null;
        }

        public boolean stillValid(Player player) {
            return false;
        }

        public void slotsChanged(Container container) {
        }
    };
    private int progress;
    private int maxProgress;
    private int energyConsumptionLeft = -1;
    private boolean hasEnoughEnergy;
    private boolean ignoreNBT;

    public AutoCrafterBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(EPBlockEntities.AUTO_CRAFTER_ENTITY.get(), blockPos, blockState, "auto_crafter", ModConfigs.COMMON_AUTO_CRAFTER_CAPACITY.getValue(), ModConfigs.COMMON_AUTO_CRAFTER_TRANSFER_RATE.getValue(), 18, UpgradeModuleModifier.SPEED, UpgradeModuleModifier.ENERGY_CONSUMPTION, UpgradeModuleModifier.ENERGY_CAPACITY);
        this.patternSlots.addListener(this.updatePatternListener);
    }

    @Override
    protected ReceiveOnlyEnergyStorage initEnergyStorage() {
        return new ReceiveOnlyEnergyStorage(0, this.baseEnergyCapacity, this.baseEnergyTransferRate){

            @Override
            public int getCapacity() {
                return Math.max(1, (int)Math.ceil((double)this.capacity * AutoCrafterBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CAPACITY)));
            }

            @Override
            public int getMaxReceive() {
                return Math.max(1, (int)Math.ceil((double)this.maxReceive * AutoCrafterBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_TRANSFER_RATE)));
            }

            @Override
            protected void onChange() {
                AutoCrafterBlockEntity.this.setChanged();
                AutoCrafterBlockEntity.this.syncEnergyToPlayers(32);
            }
        };
    }

    @Override
    protected ItemStackHandler initInventoryStorage() {
        return new ItemStackHandler(this.slotCount){

            protected void onContentsChanged(int slot) {
                AutoCrafterBlockEntity.this.setChanged();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                if (slot < 0 || slot >= 18) {
                    return super.isItemValid(slot, stack);
                }
                return slot >= 3;
            }
        };
    }

    @Override
    protected ContainerData initContainerData() {
        return new CombinedContainerData(new ProgressValueContainerData(() -> this.progress, value -> {
            this.progress = value;
        }), new ProgressValueContainerData(() -> this.maxProgress, value -> {
            this.maxProgress = value;
        }), new EnergyValueContainerData(this::getEnergyConsumptionPerTick, value -> {}), new EnergyValueContainerData(() -> this.energyConsumptionLeft, value -> {}), new BooleanValueContainerData(() -> this.hasEnoughEnergy, value -> {}), new BooleanValueContainerData(() -> this.ignoreNBT, value -> {
            this.ignoreNBT = value;
        }), new BooleanValueContainerData(() -> this.secondaryExtractMode, value -> {
            this.secondaryExtractMode = value;
        }), new BooleanValueContainerData(() -> this.allowOutputOverflow, value -> {
            this.allowOutputOverflow = value;
        }), new RedstoneModeValueContainerData(() -> this.redstoneMode, value -> {
            this.redstoneMode = value;
        }), new ComparatorModeValueContainerData(() -> this.comparatorMode, value -> {
            this.comparatorMode = value;
        }));
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        this.syncEnergyToPlayer(player);
        return new AutoCrafterMenu(id, inventory, this, this.upgradeModuleInventory, (Container)this.patternSlots, (Container)this.patternResultSlots, this.data);
    }

    @Nullable
    public IItemHandler getItemHandlerCapability(@Nullable Direction side) {
        if (side == null) {
            return this.itemHandler;
        }
        return this.itemHandlerSided;
    }

    @Nullable
    public IEnergyStorage getEnergyStorageCapability(@Nullable Direction side) {
        return this.energyStorage;
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        nbt.put("pattern", this.savePatternContainer(registries));
        if (this.craftingRecipe != null) {
            nbt.put("recipe.id", (Tag)StringTag.valueOf((String)this.craftingRecipe.id().toString()));
        }
        nbt.put("recipe.progress", (Tag)IntTag.valueOf((int)this.progress));
        nbt.put("recipe.max_progress", (Tag)IntTag.valueOf((int)this.maxProgress));
        nbt.put("recipe.energy_consumption_left", (Tag)IntTag.valueOf((int)this.energyConsumptionLeft));
        nbt.putBoolean("ignore_nbt", this.ignoreNBT);
        nbt.putBoolean("secondary_extract_mode", this.secondaryExtractMode);
        nbt.putBoolean("allow_output_overflow", this.allowOutputOverflow);
    }

    private Tag savePatternContainer(HolderLookup.Provider registries) {
        NonNullList items = NonNullList.withSize((int)this.patternSlots.getContainerSize(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < this.patternSlots.getContainerSize(); ++i) {
            items.set(i, (Object)this.patternSlots.getItem(i));
        }
        return ContainerHelper.saveAllItems((CompoundTag)new CompoundTag(), (NonNullList)items, (HolderLookup.Provider)registries);
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.loadPatternContainer(nbt.getCompound("pattern"), registries);
        if (nbt.contains("recipe.id")) {
            Tag tag = nbt.get("recipe.id");
            if (!(tag instanceof StringTag)) {
                throw new IllegalArgumentException("Tag must be of type StringTag!");
            }
            StringTag stringTag = (StringTag)tag;
            this.recipeIdForSetRecipe = ResourceLocation.tryParse((String)stringTag.getAsString());
        }
        this.progress = nbt.getInt("recipe.progress");
        this.maxProgress = nbt.getInt("recipe.max_progress");
        this.energyConsumptionLeft = nbt.getInt("recipe.energy_consumption_left");
        this.ignoreNBT = nbt.getBoolean("ignore_nbt");
        this.secondaryExtractMode = nbt.getBoolean("secondary_extract_mode");
        this.allowOutputOverflow = !nbt.contains("allow_output_overflow") || nbt.getBoolean("allow_output_overflow");
    }

    private void loadPatternContainer(CompoundTag tag, HolderLookup.Provider registries) {
        this.patternSlots.removeListener(this.updatePatternListener);
        NonNullList items = NonNullList.withSize((int)this.patternSlots.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)tag, (NonNullList)items, (HolderLookup.Provider)registries);
        for (int i = 0; i < this.patternSlots.getContainerSize(); ++i) {
            this.patternSlots.setItem(i, (ItemStack)items.get(i));
        }
        this.patternSlots.addListener(this.updatePatternListener);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, AutoCrafterBlockEntity blockEntity) {
        if (level.isClientSide) {
            return;
        }
        if (!blockEntity.hasRecipeLoaded) {
            blockEntity.updateRecipe();
            if (blockEntity.craftingRecipe == null) {
                blockEntity.resetProgress();
            }
            AutoCrafterBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)state);
        }
        if (!blockEntity.redstoneMode.isActive((Boolean)state.getValue((Property)AutoCrafterBlock.POWERED))) {
            return;
        }
        int itemCount = 0;
        for (int i = 0; i < blockEntity.patternSlots.getContainerSize(); ++i) {
            if (blockEntity.patternSlots.getItem(i).isEmpty()) continue;
            ++itemCount;
        }
        if (itemCount == 0) {
            return;
        }
        if (blockEntity.craftingRecipe != null && (blockEntity.progress > 0 || blockEntity.canInsertItemsIntoOutputSlots() && blockEntity.canExtractItemsFromInput())) {
            if (!blockEntity.canInsertItemsIntoOutputSlots() || !blockEntity.canExtractItemsFromInput()) {
                return;
            }
            if (blockEntity.maxProgress == 0) {
                blockEntity.maxProgress = Math.max(1, (int)Math.ceil((double)RECIPE_DURATION / blockEntity.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.SPEED)));
            }
            int energyConsumptionPerTick = Math.max(1, (int)Math.ceil((double)(itemCount * ENERGY_CONSUMPTION_PER_TICK_PER_INGREDIENT) * blockEntity.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CONSUMPTION)));
            if (blockEntity.progress == 0) {
                if (!blockEntity.canExtractItemsFromInput()) {
                    return;
                }
                blockEntity.energyConsumptionLeft = energyConsumptionPerTick * blockEntity.maxProgress;
            }
            if (blockEntity.progress < 0 || blockEntity.maxProgress < 0 || blockEntity.energyConsumptionLeft < 0) {
                blockEntity.resetProgress();
                AutoCrafterBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)state);
                return;
            }
            if (energyConsumptionPerTick <= ((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getEnergy()) {
                ((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).setEnergy(((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getEnergy() - energyConsumptionPerTick);
                blockEntity.energyConsumptionLeft -= energyConsumptionPerTick;
                ++blockEntity.progress;
                if (blockEntity.progress >= blockEntity.maxProgress) {
                    SimpleContainer patternSlotsForRecipe = blockEntity.ignoreNBT ? blockEntity.replaceCraftingPatternWithCurrentNBTItems(blockEntity.patternSlots) : blockEntity.patternSlots;
                    TransientCraftingContainer copyOfPatternSlots = new TransientCraftingContainer(blockEntity.dummyContainerMenu, 3, 3);
                    for (int i = 0; i < patternSlotsForRecipe.getContainerSize(); ++i) {
                        copyOfPatternSlots.setItem(i, patternSlotsForRecipe.getItem(i));
                    }
                    blockEntity.extractItems();
                    blockEntity.craftItem((CraftingContainer)copyOfPatternSlots);
                }
                AutoCrafterBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)state);
            } else {
                blockEntity.hasEnoughEnergy = false;
                AutoCrafterBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)state);
            }
        } else {
            blockEntity.resetProgress();
            AutoCrafterBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)state);
        }
    }

    protected final int getEnergyConsumptionPerTick() {
        int itemCount = 0;
        for (int i = 0; i < this.patternSlots.getContainerSize(); ++i) {
            if (this.patternSlots.getItem(i).isEmpty()) continue;
            ++itemCount;
        }
        if (itemCount == 0 || this.craftingRecipe == null || this.progress <= 0) {
            return -1;
        }
        return Math.max(1, (int)Math.ceil((double)(itemCount * ENERGY_CONSUMPTION_PER_TICK_PER_INGREDIENT) * this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CONSUMPTION)));
    }

    private void resetProgress() {
        this.progress = 0;
        this.maxProgress = 0;
        this.energyConsumptionLeft = -1;
        this.hasEnoughEnergy = true;
    }

    public void resetProgressAndMarkAsChanged() {
        this.resetProgress();
        AutoCrafterBlockEntity.setChanged((Level)this.level, (BlockPos)this.getBlockPos(), (BlockState)this.getBlockState());
    }

    public void cycleRecipe() {
        SimpleContainer patternSlotsForRecipe = this.ignoreNBT ? this.replaceCraftingPatternWithCurrentNBTItems(this.patternSlots) : this.patternSlots;
        TransientCraftingContainer copyOfPatternSlots = new TransientCraftingContainer(this.dummyContainerMenu, 3, 3);
        for (int i = 0; i < patternSlotsForRecipe.getContainerSize(); ++i) {
            copyOfPatternSlots.setItem(i, patternSlotsForRecipe.getItem(i));
        }
        List<RecipeHolder<CraftingRecipe>> recipes = this.getRecipesFor((CraftingContainer)copyOfPatternSlots, this.level);
        if (recipes.isEmpty()) {
            this.updateRecipe();
            return;
        }
        if (this.recipeIdForSetRecipe == null) {
            this.recipeIdForSetRecipe = this.craftingRecipe == null || this.craftingRecipe.id() == null ? recipes.get(0).id() : this.craftingRecipe.id();
        }
        for (int i = 0; i < recipes.size(); ++i) {
            if (!Objects.equals(recipes.get(i).id(), this.recipeIdForSetRecipe)) continue;
            this.recipeIdForSetRecipe = recipes.get((i + 1) % recipes.size()).id();
            break;
        }
        this.updateRecipe();
    }

    public void setRecipeIdForSetRecipe(ResourceLocation recipeIdForSetRecipe) {
        this.recipeIdForSetRecipe = recipeIdForSetRecipe;
        this.updateRecipe();
    }

    private void updateRecipe() {
        if (this.level == null) {
            return;
        }
        RecipeHolder<CraftingRecipe> oldRecipe = null;
        ItemStack oldResult = null;
        if (this.hasRecipeLoaded && this.craftingRecipe != null && this.oldCopyOfRecipe != null) {
            oldRecipe = this.craftingRecipe;
            oldResult = this.craftingRecipe.value() instanceof CustomRecipe ? ((CraftingRecipe)this.craftingRecipe.value()).assemble((RecipeInput)this.oldCopyOfRecipe.asCraftInput(), (HolderLookup.Provider)this.level.registryAccess()) : ((CraftingRecipe)this.craftingRecipe.value()).getResultItem((HolderLookup.Provider)this.level.registryAccess());
        }
        this.hasRecipeLoaded = true;
        SimpleContainer patternSlotsForRecipe = this.ignoreNBT ? this.replaceCraftingPatternWithCurrentNBTItems(this.patternSlots) : this.patternSlots;
        TransientCraftingContainer copyOfPatternSlots = new TransientCraftingContainer(this.dummyContainerMenu, 3, 3);
        for (int i = 0; i < patternSlotsForRecipe.getContainerSize(); ++i) {
            copyOfPatternSlots.setItem(i, patternSlotsForRecipe.getItem(i));
        }
        Optional<Pair<ResourceLocation, RecipeHolder<CraftingRecipe>>> recipe = this.getRecipeFor((CraftingContainer)copyOfPatternSlots, this.level, this.recipeIdForSetRecipe);
        if (recipe.isPresent()) {
            this.craftingRecipe = (RecipeHolder)recipe.get().getSecond();
            if (this.recipeIdForSetRecipe != null && !Objects.equals(this.craftingRecipe.id(), this.recipeIdForSetRecipe)) {
                this.recipeIdForSetRecipe = this.craftingRecipe.id();
                this.resetProgress();
            }
            ItemStack resultItemStack = this.craftingRecipe.value() instanceof CustomRecipe ? ((CraftingRecipe)this.craftingRecipe.value()).assemble((RecipeInput)copyOfPatternSlots.asCraftInput(), (HolderLookup.Provider)this.level.registryAccess()) : ((CraftingRecipe)this.craftingRecipe.value()).getResultItem((HolderLookup.Provider)this.level.registryAccess());
            this.patternResultSlots.setItem(0, resultItemStack);
            if (!(oldRecipe == null || oldResult == null || this.oldCopyOfRecipe == null || this.craftingRecipe == oldRecipe && ItemStack.isSameItemSameComponents((ItemStack)resultItemStack, (ItemStack)oldResult))) {
                this.resetProgress();
            }
            this.oldCopyOfRecipe = new TransientCraftingContainer(this.dummyContainerMenu, 3, 3);
            for (int i = 0; i < patternSlotsForRecipe.getContainerSize(); ++i) {
                this.oldCopyOfRecipe.setItem(i, copyOfPatternSlots.getItem(i).copy());
            }
        } else {
            this.recipeIdForSetRecipe = null;
            this.craftingRecipe = null;
            this.patternResultSlots.setItem(0, ItemStack.EMPTY);
            this.oldCopyOfRecipe = null;
            this.resetProgress();
        }
    }

    private void extractItems() {
        SimpleContainer patternSlotsForRecipe = this.ignoreNBT ? this.replaceCraftingPatternWithCurrentNBTItems(this.patternSlots) : this.patternSlots;
        ArrayList<ItemStack> patternItemStacks = new ArrayList<ItemStack>(9);
        for (int i = 0; i < patternSlotsForRecipe.getContainerSize(); ++i) {
            if (patternSlotsForRecipe.getItem(i).isEmpty()) continue;
            patternItemStacks.add(patternSlotsForRecipe.getItem(i));
        }
        List<ItemStack> itemStacksExtract = ItemStackUtils.combineItemStacks(patternItemStacks);
        block1: for (ItemStack itemStack : itemStacksExtract) {
            for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                ItemStack ret;
                ItemStack testItemStack = this.itemHandler.getStackInSlot(i);
                if (!ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)testItemStack) || (ret = this.itemHandler.extractItem(i, itemStack.getCount(), false)).isEmpty()) continue;
                int amount = ret.getCount();
                if (amount == itemStack.getCount()) continue block1;
                itemStack.shrink(amount);
            }
        }
    }

    private void craftItem(CraftingContainer copyOfPatternSlots) {
        if (this.craftingRecipe == null) {
            this.resetProgress();
            return;
        }
        ArrayList<ItemStack> outputItemStacks = new ArrayList<ItemStack>(10);
        ItemStack resultItemStack = this.craftingRecipe.value() instanceof CustomRecipe ? ((CraftingRecipe)this.craftingRecipe.value()).assemble((RecipeInput)copyOfPatternSlots.asCraftInput(), (HolderLookup.Provider)this.level.registryAccess()) : ((CraftingRecipe)this.craftingRecipe.value()).getResultItem((HolderLookup.Provider)this.level.registryAccess());
        outputItemStacks.add(resultItemStack);
        for (ItemStack remainingItem : ((CraftingRecipe)this.craftingRecipe.value()).getRemainingItems((RecipeInput)copyOfPatternSlots.asCraftInput())) {
            if (remainingItem.isEmpty()) continue;
            outputItemStacks.add(remainingItem);
        }
        List<ItemStack> itemStacksInsert = ItemStackUtils.combineItemStacks(outputItemStacks);
        int outputSlotCount = this.allowOutputOverflow ? this.itemHandler.getSlots() : 3;
        ArrayList<Integer> emptyIndices = new ArrayList<Integer>(outputSlotCount);
        block1: for (ItemStack itemStack : itemStacksInsert) {
            for (int i = 0; i < outputSlotCount; ++i) {
                int amount;
                ItemStack testItemStack = this.itemHandler.getStackInSlot(i);
                if (emptyIndices.contains(i)) continue;
                if (testItemStack.isEmpty()) {
                    emptyIndices.add(i);
                    continue;
                }
                if (!ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)testItemStack) || (amount = Math.min(itemStack.getCount(), testItemStack.getMaxStackSize() - testItemStack.getCount())) <= 0) continue;
                this.itemHandler.setStackInSlot(i, this.itemHandler.getStackInSlot(i).copyWithCount(testItemStack.getCount() + amount));
                itemStack.setCount(itemStack.getCount() - amount);
                if (itemStack.isEmpty()) continue block1;
            }
            if (emptyIndices.isEmpty()) continue;
            this.itemHandler.setStackInSlot(((Integer)emptyIndices.remove(0)).intValue(), itemStack);
        }
        if (this.ignoreNBT) {
            this.updateRecipe();
        }
        this.resetProgress();
    }

    private boolean canExtractItemsFromInput() {
        if (this.craftingRecipe == null) {
            return false;
        }
        SimpleContainer patternSlotsForRecipe = this.ignoreNBT ? this.replaceCraftingPatternWithCurrentNBTItems(this.patternSlots) : this.patternSlots;
        ArrayList<ItemStack> patternItemStacks = new ArrayList<ItemStack>(9);
        for (int i = 0; i < patternSlotsForRecipe.getContainerSize(); ++i) {
            if (patternSlotsForRecipe.getItem(i).isEmpty()) continue;
            patternItemStacks.add(patternSlotsForRecipe.getItem(i));
        }
        List<ItemStack> itemStacks = ItemStackUtils.combineItemStacks(patternItemStacks);
        ArrayList<Integer> checkedIndices = new ArrayList<Integer>(18);
        for (int i = itemStacks.size() - 1; i >= 0; --i) {
            block6: {
                ItemStack itemStack = itemStacks.get(i);
                for (int j = 0; j < this.itemHandler.getSlots(); ++j) {
                    if (checkedIndices.contains(j)) continue;
                    ItemStack testItemStack = this.itemHandler.getStackInSlot(j);
                    if (testItemStack.isEmpty()) {
                        checkedIndices.add(j);
                        continue;
                    }
                    if (!ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)testItemStack)) continue;
                    int amount = Math.min(itemStack.getCount(), testItemStack.getCount());
                    checkedIndices.add(j);
                    if (amount != itemStack.getCount()) {
                        itemStack.shrink(amount);
                        continue;
                    }
                    break block6;
                }
                return false;
            }
            itemStacks.remove(i);
        }
        return itemStacks.isEmpty();
    }

    private boolean canInsertItemsIntoOutputSlots() {
        ItemStack resultItemStack;
        if (this.craftingRecipe == null) {
            return false;
        }
        SimpleContainer patternSlotsForRecipe = this.ignoreNBT ? this.replaceCraftingPatternWithCurrentNBTItems(this.patternSlots) : this.patternSlots;
        TransientCraftingContainer copyOfPatternSlots = new TransientCraftingContainer(this.dummyContainerMenu, 3, 3);
        for (int i = 0; i < patternSlotsForRecipe.getContainerSize(); ++i) {
            copyOfPatternSlots.setItem(i, patternSlotsForRecipe.getItem(i));
        }
        ArrayList<ItemStack> outputItemStacks = new ArrayList<ItemStack>(10);
        ItemStack itemStack = resultItemStack = this.craftingRecipe.value() instanceof CustomRecipe ? ((CraftingRecipe)this.craftingRecipe.value()).assemble((RecipeInput)copyOfPatternSlots.asCraftInput(), (HolderLookup.Provider)this.level.registryAccess()) : ((CraftingRecipe)this.craftingRecipe.value()).getResultItem((HolderLookup.Provider)this.level.registryAccess());
        if (!resultItemStack.isEmpty()) {
            outputItemStacks.add(resultItemStack);
        }
        for (ItemStack remainingItem : ((CraftingRecipe)this.craftingRecipe.value()).getRemainingItems((RecipeInput)copyOfPatternSlots.asCraftInput())) {
            if (remainingItem.isEmpty()) continue;
            outputItemStacks.add(remainingItem);
        }
        List<ItemStack> itemStacks = ItemStackUtils.combineItemStacks(outputItemStacks);
        int outputSlotCount = this.allowOutputOverflow ? this.itemHandler.getSlots() : 3;
        ArrayList<Integer> checkedIndices = new ArrayList<Integer>(outputSlotCount);
        ArrayList<Integer> emptyIndices = new ArrayList<Integer>(outputSlotCount);
        block2: for (int i = itemStacks.size() - 1; i >= 0; --i) {
            ItemStack itemStack2 = itemStacks.get(i);
            for (int j = 0; j < outputSlotCount; ++j) {
                if (checkedIndices.contains(j) || emptyIndices.contains(j)) continue;
                ItemStack testItemStack = this.itemHandler.getStackInSlot(j);
                if (testItemStack.isEmpty()) {
                    emptyIndices.add(j);
                    continue;
                }
                if (!ItemStack.isSameItemSameComponents((ItemStack)itemStack2, (ItemStack)testItemStack)) continue;
                int amount = Math.min(itemStack2.getCount(), testItemStack.getMaxStackSize() - testItemStack.getCount());
                if (amount + testItemStack.getCount() == testItemStack.getMaxStackSize()) {
                    checkedIndices.add(j);
                }
                if (amount == itemStack2.getCount()) {
                    itemStacks.remove(i);
                    continue block2;
                }
                itemStack2.shrink(amount);
            }
            if (emptyIndices.isEmpty()) {
                return false;
            }
            int index = (Integer)emptyIndices.remove(0);
            if (itemStack2.getCount() == itemStack2.getMaxStackSize()) {
                checkedIndices.add(index);
            }
            itemStacks.remove(i);
        }
        return itemStacks.isEmpty();
    }

    private boolean isOutputOrCraftingRemainderOfInput(ItemStack itemStack) {
        ItemStack resultItemStack;
        if (this.craftingRecipe == null) {
            return false;
        }
        SimpleContainer patternSlotsForRecipe = this.ignoreNBT ? this.replaceCraftingPatternWithCurrentNBTItems(this.patternSlots) : this.patternSlots;
        TransientCraftingContainer copyOfPatternSlots = new TransientCraftingContainer(this.dummyContainerMenu, 3, 3);
        for (int i = 0; i < patternSlotsForRecipe.getContainerSize(); ++i) {
            copyOfPatternSlots.setItem(i, patternSlotsForRecipe.getItem(i));
        }
        ItemStack itemStack2 = resultItemStack = this.craftingRecipe.value() instanceof CustomRecipe ? ((CraftingRecipe)this.craftingRecipe.value()).assemble((RecipeInput)copyOfPatternSlots.asCraftInput(), (HolderLookup.Provider)this.level.registryAccess()) : ((CraftingRecipe)this.craftingRecipe.value()).getResultItem((HolderLookup.Provider)this.level.registryAccess());
        if (ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)resultItemStack)) {
            return true;
        }
        for (ItemStack remainingItem : ((CraftingRecipe)this.craftingRecipe.value()).getRemainingItems((RecipeInput)copyOfPatternSlots.asCraftInput())) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)remainingItem)) continue;
            return true;
        }
        return false;
    }

    private boolean isInput(ItemStack itemStack) {
        if (this.craftingRecipe == null) {
            return false;
        }
        for (int i = 0; i < this.patternSlots.getContainerSize(); ++i) {
            if (!(this.ignoreNBT ? ItemStack.isSameItem((ItemStack)itemStack, (ItemStack)this.patternSlots.getItem(i)) : ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)this.patternSlots.getItem(i)))) continue;
            return true;
        }
        return false;
    }

    private SimpleContainer replaceCraftingPatternWithCurrentNBTItems(SimpleContainer container) {
        SimpleContainer copyOfContainer = new SimpleContainer(container.getContainerSize());
        for (int i = 0; i < container.getContainerSize(); ++i) {
            copyOfContainer.setItem(i, container.getItem(i).copy());
        }
        HashMap<Integer, Integer> usedItemCounts = new HashMap<Integer, Integer>();
        block1: for (int i = 0; i < copyOfContainer.getContainerSize(); ++i) {
            int usedCount;
            ItemStack testItemStack;
            int j;
            ItemStack itemStack = copyOfContainer.getItem(i);
            if (itemStack.isEmpty()) continue;
            for (j = 0; j < this.itemHandler.getSlots(); ++j) {
                testItemStack = this.itemHandler.getStackInSlot(j).copy();
                usedCount = usedItemCounts.getOrDefault(j, 0);
                testItemStack.setCount(testItemStack.getCount() - usedCount);
                if (testItemStack.getCount() <= 0 || !ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)testItemStack)) continue;
                usedItemCounts.put(j, usedCount + 1);
                continue block1;
            }
            for (j = 0; j < this.itemHandler.getSlots(); ++j) {
                testItemStack = this.itemHandler.getStackInSlot(j).copy();
                usedCount = usedItemCounts.getOrDefault(j, 0);
                testItemStack.setCount(testItemStack.getCount() - usedCount);
                if (testItemStack.getCount() <= 0 || !ItemStack.isSameItem((ItemStack)itemStack, (ItemStack)testItemStack)) continue;
                usedItemCounts.put(j, usedCount + 1);
                copyOfContainer.setItem(i, testItemStack.copyWithCount(1));
                continue block1;
            }
            return copyOfContainer;
        }
        return copyOfContainer;
    }

    private List<RecipeHolder<CraftingRecipe>> getRecipesFor(CraftingContainer patternSlots, Level level) {
        return level.getRecipeManager().getAllRecipesFor(RecipeType.CRAFTING).stream().filter(recipe -> !RECIPE_BLACKLIST.contains(recipe.id())).filter(recipe -> ((CraftingRecipe)recipe.value()).matches((RecipeInput)patternSlots.asCraftInput(), level)).sorted(Comparator.comparing(recipe -> ((CraftingRecipe)recipe.value()).getResultItem((HolderLookup.Provider)level.registryAccess()).getDescriptionId())).toList();
    }

    private Optional<Pair<ResourceLocation, RecipeHolder<CraftingRecipe>>> getRecipeFor(CraftingContainer patternSlots, Level level, ResourceLocation recipeId) {
        List<RecipeHolder<CraftingRecipe>> recipes = this.getRecipesFor(patternSlots, level);
        Optional<RecipeHolder> recipe = recipes.stream().filter(r -> r.id().equals((Object)recipeId)).findFirst();
        return recipe.or(() -> recipes.stream().findFirst()).map(r -> Pair.of((Object)r.id(), (Object)r));
    }

    @Override
    protected void updateUpgradeModules() {
        this.resetProgress();
        super.updateUpgradeModules();
    }

    public void setIgnoreNBT(boolean ignoreNBT) {
        this.ignoreNBT = ignoreNBT;
        this.updateRecipe();
        AutoCrafterBlockEntity.setChanged((Level)this.level, (BlockPos)this.getBlockPos(), (BlockState)this.getBlockState());
    }

    public void setSecondaryExtractMode(boolean secondaryExtractMode) {
        this.secondaryExtractMode = secondaryExtractMode;
        AutoCrafterBlockEntity.setChanged((Level)this.level, (BlockPos)this.getBlockPos(), (BlockState)this.getBlockState());
    }

    public void setAllowOutputOverflow(boolean allowOutputOverflow) {
        this.allowOutputOverflow = allowOutputOverflow;
        AutoCrafterBlockEntity.setChanged((Level)this.level, (BlockPos)this.getBlockPos(), (BlockState)this.getBlockState());
    }

    @Override
    public void setCheckbox(int checkboxId, boolean checked) {
        switch (checkboxId) {
            case 0: {
                this.setIgnoreNBT(checked);
                break;
            }
            case 1: {
                this.setSecondaryExtractMode(checked);
                break;
            }
            case 2: {
                this.setAllowOutputOverflow(checked);
            }
        }
    }
}

