/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block;

import com.mojang.serialization.MapCodec;
import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.WeatherControllerBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class WeatherControllerBlock
extends BaseEntityBlock {
    public static final MapCodec<WeatherControllerBlock> CODEC = WeatherControllerBlock.simpleCodec(WeatherControllerBlock::new);

    public WeatherControllerBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState state) {
        return new WeatherControllerBlockEntity(blockPos, state);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public void onRemove(BlockState state, Level level, BlockPos blockPos, BlockState newState, boolean isMoving) {
        if (state.getBlock() == newState.getBlock()) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (!(blockEntity instanceof WeatherControllerBlockEntity)) {
            return;
        }
        ((WeatherControllerBlockEntity)blockEntity).drops(level, blockPos);
        super.onRemove(state, level, blockPos, newState, isMoving);
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos blockPos, Player player, BlockHitResult hit) {
        if (level.isClientSide()) {
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (!(blockEntity instanceof WeatherControllerBlockEntity)) {
            throw new IllegalStateException("Container is invalid");
        }
        player.openMenu((MenuProvider)((WeatherControllerBlockEntity)blockEntity), blockPos);
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return WeatherControllerBlock.createTickerHelper(type, EPBlockEntities.WEATHER_CONTROLLER_ENTITY.get(), WeatherControllerBlockEntity::tick);
    }
}

