/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import me.jddev0.ep.block.EPBlockStateProperties;
import me.jddev0.ep.block.WrenchConfigurable;
import me.jddev0.ep.block.entity.ItemConveyorBeltBlockEntity;
import me.jddev0.ep.machine.tier.ConveyorBeltTier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemConveyorBeltBlock
extends BaseEntityBlock
implements WrenchConfigurable {
    public static final MapCodec<ItemConveyorBeltBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.NON_EMPTY_STRING.xmap(ConveyorBeltTier::valueOf, Enum::toString).fieldOf("tier").forGetter(ItemConveyorBeltBlock::getTier), (App)BlockBehaviour.Properties.CODEC.fieldOf("properties").forGetter(BlockBehaviour::properties)).apply((Applicative)instance, ItemConveyorBeltBlock::new));
    public static final EnumProperty<EPBlockStateProperties.ConveyorBeltDirection> FACING = EPBlockStateProperties.CONVEYOR_BELT_FACING;
    protected static final VoxelShape SHAPE_FLAT = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    protected static final VoxelShape SHAPE_HALF_BLOCK = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    private final ConveyorBeltTier tier;

    protected ItemConveyorBeltBlock(ConveyorBeltTier tier, BlockBehaviour.Properties props) {
        super(props);
        this.tier = tier;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)((Object)EPBlockStateProperties.ConveyorBeltDirection.NORTH_SOUTH)));
    }

    public ConveyorBeltTier getTier() {
        return this.tier;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState state) {
        return new ItemConveyorBeltBlockEntity(blockPos, state, this.tier);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos blockPos) {
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (!(blockEntity instanceof ItemConveyorBeltBlockEntity)) {
            return super.getAnalogOutputSignal(state, level, blockPos);
        }
        ItemConveyorBeltBlockEntity itemConveyorBeltBlockEntity = (ItemConveyorBeltBlockEntity)blockEntity;
        return itemConveyorBeltBlockEntity.getRedstoneOutput();
    }

    public void onRemove(BlockState state, Level level, BlockPos blockPos, BlockState newState, boolean isMoving) {
        if (state.getBlock() == newState.getBlock()) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (!(blockEntity instanceof ItemConveyorBeltBlockEntity)) {
            return;
        }
        ((ItemConveyorBeltBlockEntity)blockEntity).drops(level, blockPos);
        super.onRemove(state, level, blockPos, newState, isMoving);
    }

    @Override
    @NotNull
    public InteractionResult onUseWrench(UseOnContext useOnContext, Direction selectedFace, boolean nextPreviousValue) {
        Level level = useOnContext.getLevel();
        BlockPos blockPos = useOnContext.getClickedPos();
        if (level.isClientSide || !(level.getBlockEntity(blockPos) instanceof ItemConveyorBeltBlockEntity)) {
            return InteractionResult.SUCCESS;
        }
        BlockState state = level.getBlockState(blockPos);
        Player player = useOnContext.getPlayer();
        EPBlockStateProperties.ConveyorBeltDirection facing = (EPBlockStateProperties.ConveyorBeltDirection)((Object)state.getValue(FACING));
        Object shape = nextPreviousValue ? (facing.isAscending() ? null : (facing.isDescending() ? Boolean.valueOf(true) : Boolean.valueOf(false))) : (facing.isAscending() ? Boolean.valueOf(false) : (facing.isDescending() ? null : Boolean.valueOf(true)));
        level.setBlock(blockPos, (BlockState)state.setValue(FACING, (Comparable)((Object)EPBlockStateProperties.ConveyorBeltDirection.of(facing.getDirection(), (Boolean)shape))), 3);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"tooltip.energizedpower.item_conveyor_belt.wrench_configuration.changed", (Object[])new Object[]{Component.translatable((String)("tooltip.energizedpower.conveyor_belt_direction.slope." + (shape == null ? "flat" : (((Boolean)shape).booleanValue() ? "ascending" : "descending")))).withStyle(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.BOLD})}).withStyle(ChatFormatting.GREEN)));
        }
        return InteractionResult.SUCCESS;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)((Object)EPBlockStateProperties.ConveyorBeltDirection.of(context.getHorizontalDirection(), null)));
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        EPBlockStateProperties.ConveyorBeltDirection facing = (EPBlockStateProperties.ConveyorBeltDirection)((Object)state.getValue(FACING));
        Boolean slope = facing.getSlope();
        return (BlockState)state.setValue(FACING, (Comparable)((Object)EPBlockStateProperties.ConveyorBeltDirection.of(rotation.rotate(facing.getDirection()), slope)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation(((EPBlockStateProperties.ConveyorBeltDirection)((Object)state.getValue(FACING))).getDirection()));
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        EPBlockStateProperties.ConveyorBeltDirection facing = (EPBlockStateProperties.ConveyorBeltDirection)((Object)blockState.getValue(FACING));
        if (facing.isAscending() || facing.isDescending()) {
            return SHAPE_HALF_BLOCK;
        }
        return SHAPE_FLAT;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{FACING});
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return ItemConveyorBeltBlock.createTickerHelper(type, this.tier.getItemConveyorBeltBlockEntityFromTier(), ItemConveyorBeltBlockEntity::tick);
    }

    public static class Item
    extends BlockItem {
        private final ConveyorBeltTier tier;

        public Item(Block block, Item.Properties props, ConveyorBeltTier tier) {
            super(block, props);
            this.tier = tier;
        }

        public ConveyorBeltTier getTier() {
            return this.tier;
        }

        public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> components, TooltipFlag flag) {
            if (Screen.hasShiftDown()) {
                components.add((Component)Component.translatable((String)"tooltip.energizedpower.wrench_configurable").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            } else {
                components.add((Component)Component.translatable((String)"tooltip.energizedpower.shift_details.txt").withStyle(ChatFormatting.YELLOW));
            }
        }
    }
}

