/*
 * Decompiled with CFR 0.152.
 */
package net.armory_rpgs.datagen.recipe;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.armory_rpgs.datagen.recipe.SmithingUpgradeRecipe;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;

public abstract class SmithingRecipeProvider
implements DataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final CompletableFuture<HolderLookup.Provider> registryLookup;
    protected final FabricDataOutput dataOutput;
    private final PackOutput.PathProvider recipePathResolver;

    public SmithingRecipeProvider(FabricDataOutput dataOutput, CompletableFuture<HolderLookup.Provider> registryLookup) {
        this.dataOutput = dataOutput;
        this.registryLookup = registryLookup;
        this.recipePathResolver = dataOutput.createRegistryElementsPathProvider(Registries.RECIPE);
    }

    public abstract void generateRecipes(Builder var1);

    public CompletableFuture<?> run(CachedOutput writer) {
        Builder builder = new Builder();
        this.generateRecipes(builder);
        List<Entry> entries = builder.entries;
        ArrayList<CompletableFuture> writes = new ArrayList<CompletableFuture>();
        for (Entry entry : entries) {
            JsonElement json = GSON.toJsonTree((Object)entry.recipe);
            Path path = this.recipePathResolver.json(entry.id);
            writes.add(DataProvider.saveStable((CachedOutput)writer, (JsonElement)json, (Path)path));
        }
        return CompletableFuture.allOf(writes.toArray(new CompletableFuture[0]));
    }

    public String getName() {
        return "Smithing Recipe Generator";
    }

    public static class Builder {
        public final List<Entry> entries = new ArrayList<Entry>();

        public Builder add(ResourceLocation recipeId, SmithingUpgradeRecipe recipe) {
            this.entries.add(new Entry(recipeId, recipe));
            return this;
        }

        public Builder add(String namespace, String path, SmithingUpgradeRecipe recipe) {
            return this.add(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path), recipe);
        }
    }

    public record Entry(ResourceLocation id, SmithingUpgradeRecipe recipe) {
    }
}

