/*
 * Decompiled with CFR 0.152.
 */
package net.rogues.effect;

import java.util.Collection;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.spell_engine.api.effect.StatusEffectClassification;
import net.spell_engine.utils.WorldScheduler;

public class ChargeEffect
extends MobEffect {
    protected ChargeEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    private void removeMovementImpairingEffects(LivingEntity entity) {
        if (entity.level().isClientSide()) {
            return;
        }
        Collection effects = entity.getActiveEffects();
        for (MobEffectInstance instance : effects) {
            Holder effect = instance.getEffect();
            if (!StatusEffectClassification.isMovementImpairing((Holder)effect)) continue;
            ((WorldScheduler)entity.level()).schedule(1, () -> entity.removeEffect(instance.getEffect()));
        }
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        this.removeMovementImpairingEffects(entity);
        return true;
    }

    public void onEffectStarted(LivingEntity entity, int amplifier) {
        super.onEffectStarted(entity, amplifier);
        this.removeMovementImpairingEffects(entity);
    }
}

