/*
 * Decompiled with CFR 0.152.
 */
package net.runes.crafting;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.ItemCombinerMenuSlotDefinition;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.runes.crafting.RuneCrafter;
import net.runes.crafting.RuneCrafting;
import net.runes.crafting.RuneCraftingBlock;
import net.runes.crafting.RuneCraftingRecipe;
import net.runes.crafting.RuneCraftingRecipeInput;
import org.jetbrains.annotations.Nullable;

public class RuneCraftingScreenHandler
extends ItemCombinerMenu {
    public static final MenuType<RuneCraftingScreenHandler> HANDLER_TYPE = new MenuType(RuneCraftingScreenHandler::new, FeatureFlags.VANILLA_SET);
    private final Level world;
    @Nullable
    private RecipeHolder<RuneCraftingRecipe> currentRecipe;
    private final List<RecipeHolder<RuneCraftingRecipe>> recipes;

    public RuneCraftingScreenHandler(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, ContainerLevelAccess.NULL);
    }

    public RuneCraftingScreenHandler(int syncId, Inventory playerInventory, FriendlyByteBuf packetByteBuf) {
        this(syncId, playerInventory, ContainerLevelAccess.NULL);
    }

    public RuneCraftingScreenHandler(int syncId, Inventory playerInventory, ContainerLevelAccess context) {
        super(HANDLER_TYPE, syncId, playerInventory, context);
        this.world = playerInventory.player.level();
        this.recipes = this.world.getRecipeManager().getAllRecipesFor(RuneCraftingRecipe.TYPE);
    }

    protected ItemCombinerMenuSlotDefinition createInputSlotDefinitions() {
        return ItemCombinerMenuSlotDefinition.create().withSlot(0, 27, 47, stack -> true).withSlot(1, 76, 47, stack -> true).withResultSlot(2, 134, 47).build();
    }

    protected boolean isValidBlock(BlockState state) {
        return state.is((Block)RuneCraftingBlock.INSTANCE);
    }

    protected boolean mayPickup(Player player, boolean present) {
        return this.currentRecipe != null && ((RuneCraftingRecipe)this.currentRecipe.value()).matches(this.createRecipeInput(), this.world);
    }

    private RuneCraftingRecipeInput createRecipeInput() {
        return new RuneCraftingRecipeInput(this.inputSlots.getItem(0), this.inputSlots.getItem(1));
    }

    protected void onTake(Player player, ItemStack stack) {
        stack.onCraftedBy(player.level(), player, stack.getCount());
        this.resultSlots.awardUsedRecipes(player, this.getInputStacks());
        this.decrementStack(0);
        this.decrementStack(1);
        RuneCrafter runeCrafter = (RuneCrafter)player;
        if (runeCrafter.shouldPlayRuneCraftingSound(player.tickCount)) {
            this.world.playLocalSound(player.getX(), player.getY(), player.getZ(), RuneCrafting.SOUND, SoundSource.BLOCKS, this.world.random.nextFloat() * 0.1f + 0.9f, 1.0f, true);
            runeCrafter.onPlayedRuneCraftingSound(player.tickCount);
        }
    }

    private List<ItemStack> getInputStacks() {
        return List.of(this.inputSlots.getItem(0), this.inputSlots.getItem(1));
    }

    private void decrementStack(int slot) {
        ItemStack itemStack = this.inputSlots.getItem(slot);
        itemStack.shrink(1);
        this.inputSlots.setItem(slot, itemStack);
    }

    public void createResult() {
        RuneCraftingRecipeInput recipeInput = this.createRecipeInput();
        Optional result = this.world.getRecipeManager().getRecipeFor(RuneCraftingRecipe.TYPE, (RecipeInput)recipeInput, this.world);
        if (result.isPresent()) {
            RecipeHolder recipeEntry = (RecipeHolder)result.get();
            ItemStack itemStack = ((RuneCraftingRecipe)recipeEntry.value()).craft(recipeInput, (HolderLookup.Provider)this.world.registryAccess());
            this.currentRecipe = recipeEntry;
            this.resultSlots.setRecipeUsed(recipeEntry);
            this.resultSlots.setItem(0, itemStack);
        } else {
            this.resultSlots.setItem(0, ItemStack.EMPTY);
        }
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slot) {
        return slot.container != this.resultSlots && super.canTakeItemForPickAll(stack, slot);
    }
}

