/*
 * Decompiled with CFR 0.152.
 */
package net.skill_tree_rpgs.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.skill_tree_rpgs.skills.SkillDefinitions;
import net.spell_engine.client.gui.SpellTooltip;
import net.spell_engine.mixin.client.ItemStackTooltipAccessor;

public class TranslationUtil {
    public static final Map<String, Supplier<List<Component>>> resolvers = new HashMap<String, Supplier<List<Component>>>();

    public static List<Component> resolve(String skillId) {
        Supplier<List<Component>> supplier = resolvers.get(skillId);
        if (supplier == null) {
            return List.of();
        }
        return supplier.get();
    }

    public static List<Component> resolveSpellDetails(ResourceLocation spellId) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return List.of();
        }
        return SpellTooltip.spellDescriptionWithDetails((ResourceLocation)spellId, (Player)player, (ItemStack)ItemStack.EMPTY, (int)0);
    }

    public static List<Component> resolveAttributeModifierTooltip(SkillDefinitions.EntityAttributeReward attributeReward) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return List.of();
        }
        ItemStackTooltipAccessor tooltipUtil = (ItemStackTooltipAccessor)ItemStack.EMPTY;
        ArrayList<Component> bonusLines = new ArrayList<Component>();
        AttributeModifier modifier = attributeReward.modifier();
        tooltipUtil.spellEngine_appendAttributeModifierTooltip(bonusLines::add, (Player)player, attributeReward.attribute(), modifier);
        return bonusLines;
    }
}

