/*
 * Decompiled with CFR 0.152.
 */
package net.spell_power.api;

import com.google.gson.annotations.JsonAdapter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.alchemy.Potion;
import net.spell_power.SpellPowerMod;
import net.spell_power.api.misc.SpellSchoolJSONAdapter;
import org.jetbrains.annotations.Nullable;

@JsonAdapter(value=SpellSchoolJSONAdapter.class)
public class SpellSchool {
    public final Archetype archetype;
    public final ResourceLocation id;
    public final int color;
    @Nullable
    private final Attribute ownedAttribute;
    @Nullable
    public final MobEffect ownedBoostEffect;
    public final ResourceKey<DamageType> damageType;
    @Nullable
    public Holder<Attribute> attributeEntry;
    @Nullable
    public Holder<Potion> potionEntry;
    private HashMap<Trait, ArrayList<Source>> sources = SpellSchool.emptyTraits();

    public SpellSchool(Archetype archetype, ResourceLocation id, int color, ResourceKey<DamageType> damageType, Holder<Attribute> attributeEntry) {
        this(archetype, id, color, damageType, null, null);
        this.attributeEntry = attributeEntry;
    }

    public SpellSchool(Archetype archetype, ResourceLocation id, int color, ResourceKey<DamageType> damageType, Attribute attribute, @Nullable MobEffect boostEffect) {
        this.archetype = archetype;
        this.id = id;
        this.color = color;
        this.damageType = damageType;
        this.ownedAttribute = attribute;
        this.ownedBoostEffect = boostEffect;
    }

    public float attributeBaseValue() {
        return this.ownedAttribute != null ? (float)this.ownedAttribute.getDefaultValue() : 0.0f;
    }

    public void registerAttribute() {
        if (this.ownedAttribute != null) {
            this.attributeEntry = Registry.registerForHolder((Registry)BuiltInRegistries.ATTRIBUTE, (ResourceLocation)this.id, (Object)this.ownedAttribute);
        }
    }

    public void registerPotion() {
        Holder entry;
        if (this.ownedBoostEffect != null && (entry = BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)this.ownedBoostEffect)) != null) {
            Potion potion = new Potion(new MobEffectInstance[]{new MobEffectInstance(entry, 3600)});
            ResourceLocation potionId = SpellPowerMod.potionIdFrom(this.id);
            Registry.register((Registry)BuiltInRegistries.POTION, (ResourceLocation)potionId, (Object)potion);
        }
    }

    public Holder<Attribute> getAttributeEntry() {
        return this.attributeEntry;
    }

    public boolean ownsAttribute() {
        return this.ownedAttribute != null;
    }

    public boolean isMagicArchetype() {
        return this.archetype == Archetype.MAGIC;
    }

    private static HashMap<Trait, ArrayList<Source>> emptyTraits() {
        HashMap<Trait, ArrayList<Source>> map = new HashMap<Trait, ArrayList<Source>>();
        for (Trait trait : Trait.values()) {
            map.put(trait, new ArrayList());
        }
        return map;
    }

    public void addSource(Trait trait, Apply apply, Function<QueryArgs, Double> function) {
        this.addSource(trait, new Source(apply, function));
    }

    public void addSource(Trait trait, Source source) {
        this.sources.get((Object)trait).add(source);
        this.sources.get((Object)trait).sort(Comparator.comparingInt(a -> a.apply.ordinal()));
    }

    public double getValue(Trait trait, QueryArgs query) {
        ArrayList<Source> traitSources = this.sources.get((Object)trait);
        float value = 0.0f;
        switch (trait.ordinal()) {
            case 0: 
            case 2: {
                value = 0.0f;
                break;
            }
            case 1: 
            case 3: {
                value = 1.0f;
            }
        }
        float multiplier = 1.0f;
        for (Source source : traitSources) {
            switch (source.apply.ordinal()) {
                case 0: {
                    value = (float)((double)value + source.function.apply(query));
                    break;
                }
                case 1: {
                    multiplier = (float)((double)multiplier + source.function.apply(query));
                }
            }
        }
        return value *= multiplier;
    }

    public static enum Archetype {
        ARCHERY,
        MAGIC,
        MELEE;

    }

    public static enum Trait {
        POWER,
        HASTE,
        CRIT_CHANCE,
        CRIT_DAMAGE;

    }

    public record Source(Apply apply, Function<QueryArgs, Double> function) {
    }

    public static enum Apply {
        ADD,
        MULTIPLY;

    }

    public record QueryArgs(LivingEntity entity) {
    }
}

